/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BaseEngineException;
import org.apache.oozie.BundleEngine;
import org.apache.oozie.BundleEngineException;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorActionInfo;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.service.BundleEngineService;
import org.apache.oozie.service.CoordinatorEngineService;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.BaseJobServlet;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.XLog;
import org.json.simple.JSONObject;

public class V1JobServlet
extends BaseJobServlet {
    private static final String INSTRUMENTATION_NAME = "v1job";

    public V1JobServlet() {
        super(INSTRUMENTATION_NAME);
    }

    @Override
    protected void startJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-W")) {
            this.startWorkflowJob(request, response);
        } else if (jobId.endsWith("-B")) {
            this.startBundleJob(request, response);
        } else {
            throw new XServletException(400, ErrorCode.E0303, new Object[0]);
        }
    }

    @Override
    protected void resumeJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-W")) {
            this.resumeWorkflowJob(request, response);
        } else if (jobId.endsWith("-B")) {
            this.resumeBundleJob(request, response);
        } else {
            this.resumeCoordinatorJob(request, response);
        }
    }

    @Override
    protected void suspendJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-W")) {
            this.suspendWorkflowJob(request, response);
        } else if (jobId.endsWith("-B")) {
            this.suspendBundleJob(request, response);
        } else {
            this.suspendCoordinatorJob(request, response);
        }
    }

    @Override
    protected void killJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-W")) {
            this.killWorkflowJob(request, response);
        } else if (jobId.endsWith("-B")) {
            this.killBundleJob(request, response);
        } else {
            this.killCoordinatorJob(request, response);
        }
    }

    @Override
    protected void changeJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-B")) {
            this.changeBundleJob(request, response);
        } else {
            this.changeCoordinatorJob(request, response);
        }
    }

    @Override
    protected JSONObject reRunJob(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws XServletException, IOException {
        JSONObject json = null;
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-W")) {
            this.reRunWorkflowJob(request, response, conf);
        } else if (jobId.endsWith("-B")) {
            this.rerunBundleJob(request, response, conf);
        } else {
            json = this.reRunCoordinatorActions(request, response, conf);
        }
        return json;
    }

    @Override
    protected JsonBean getJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException, BaseEngineException {
        ServletInputStream is = request.getInputStream();
        byte[] b = new byte[101];
        while (is.readLine(b, 0, 100) != -1) {
            XLog.getLog(((Object)((Object)this)).getClass()).warn("Printing :" + new String(b));
        }
        JsonBean jobBean = null;
        String jobId = this.getResourceName(request);
        jobBean = jobId.endsWith("-B") ? this.getBundleJob(request, response) : (jobId.endsWith("-W") ? this.getWorkflowJob(request, response) : (jobId.contains("-W@") ? this.getWorkflowAction(request, response) : (jobId.contains("-C@") ? this.getCoordinatorAction(request, response) : this.getCoordinatorJob(request, response))));
        return jobBean;
    }

    @Override
    protected String getJobDefinition(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobDefinition = null;
        String jobId = this.getResourceName(request);
        jobDefinition = jobId.endsWith("-W") ? this.getWorkflowJobDefinition(request, response) : (jobId.endsWith("-B") ? this.getBundleJobDefinition(request, response) : this.getCoordinatorJobDefinition(request, response));
        return jobDefinition;
    }

    @Override
    protected void streamJobLog(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        String jobId = this.getResourceName(request);
        if (jobId.endsWith("-W")) {
            this.streamWorkflowJobLog(request, response);
        } else if (jobId.endsWith("-B")) {
            this.streamBundleJob(request, response);
        } else {
            this.streamCoordinatorJobLog(request, response);
        }
    }

    private void startWorkflowJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.start(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void startBundleJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            bundleEngine.start(jobId);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void resumeWorkflowJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.resume(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void resumeBundleJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            bundleEngine.resume(jobId);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void resumeCoordinatorJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        String jobId = this.getResourceName(request);
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request), this.getAuthToken(request));
        try {
            coordEngine.resume(jobId);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void suspendWorkflowJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.suspend(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void suspendBundleJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            bundleEngine.suspend(jobId);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void suspendCoordinatorJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            coordEngine.suspend(jobId);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void killWorkflowJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.kill(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void killCoordinatorJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            coordEngine.kill(jobId);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void killBundleJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            bundleEngine.kill(jobId);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void changeCoordinatorJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        String changeValue = request.getParameter("value");
        try {
            coordEngine.change(jobId, changeValue);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void changeBundleJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        String changeValue = request.getParameter("value");
        try {
            bundleEngine.change(jobId, changeValue);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void reRunWorkflowJob(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws XServletException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.reRun(jobId, conf);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void rerunBundleJob(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws XServletException {
        JSONObject json = new JSONObject();
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        String coordScope = request.getParameter("coord-scope");
        String dateScope = request.getParameter("date-scope");
        String refresh = request.getParameter("refresh");
        String noCleanup = request.getParameter("nocleanup");
        XLog.getLog(((Object)((Object)this)).getClass()).info("Rerun Bundle for jobId=" + jobId + ", coordScope=" + coordScope + ", dateScope=" + dateScope + ", refresh=" + refresh + ", noCleanup=" + noCleanup);
        try {
            bundleEngine.reRun(jobId, coordScope, dateScope, Boolean.valueOf(refresh), Boolean.valueOf(noCleanup));
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private JSONObject reRunCoordinatorActions(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws XServletException {
        JSONObject json = new JSONObject();
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        String rerunType = request.getParameter("type");
        String scope = request.getParameter("scope");
        String refresh = request.getParameter("refresh");
        String noCleanup = request.getParameter("nocleanup");
        XLog.getLog(((Object)((Object)this)).getClass()).info("Rerun coordinator for jobId=" + jobId + ", rerunType=" + rerunType + ",scope=" + scope + ",refresh=" + refresh + ", noCleanup=" + noCleanup);
        try {
            CoordinatorActionInfo coordInfo = coordEngine.reRun(jobId, rerunType, scope, Boolean.valueOf(refresh), Boolean.valueOf(noCleanup));
            List<CoordinatorActionBean> actions = coordInfo.getCoordActions();
            json.put((Object)"actions", (Object)CoordinatorActionBean.toJSONArray(actions));
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JsonBean getWorkflowJob(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        JsonBean jobBean = null;
        String jobId = this.getResourceName(request);
        String startStr = request.getParameter("offset");
        String lenStr = request.getParameter("len");
        int start = startStr != null ? Integer.parseInt(startStr) : 1;
        start = start < 1 ? 1 : start;
        int len = lenStr != null ? Integer.parseInt(lenStr) : 0;
        len = len < 1 ? Integer.MAX_VALUE : len;
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
        try {
            jobBean = (JsonBean)dagEngine.getJob(jobId, start, len);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return jobBean;
    }

    private JsonBean getWorkflowAction(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
        WorkflowActionBean actionBean = null;
        String actionId = this.getResourceName(request);
        try {
            actionBean = dagEngine.getWorkflowAction(actionId);
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
        return actionBean;
    }

    private JsonBean getCoordinatorJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, BaseEngineException {
        CoordinatorJobBean jobBean = null;
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        String startStr = request.getParameter("offset");
        String lenStr = request.getParameter("len");
        int start = startStr != null ? Integer.parseInt(startStr) : 1;
        start = start < 1 ? 1 : start;
        int len = lenStr != null ? Integer.parseInt(lenStr) : 0;
        len = len < 1 ? Integer.MAX_VALUE : len;
        try {
            CoordinatorJobBean coordJob;
            jobBean = coordJob = coordEngine.getCoordJob(jobId, start, len);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
        return jobBean;
    }

    private JsonBean getBundleJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, BaseEngineException {
        BundleJobBean jobBean = null;
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            jobBean = bundleEngine.getBundleJob(jobId);
            return jobBean;
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private JsonBean getCoordinatorAction(HttpServletRequest request, HttpServletResponse response) throws XServletException, BaseEngineException {
        CoordinatorActionBean actionBean = null;
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request), this.getAuthToken(request));
        String actionId = this.getResourceName(request);
        try {
            actionBean = coordEngine.getCoordAction(actionId);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
        return actionBean;
    }

    private String getWorkflowJobDefinition(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        String wfDefinition;
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            wfDefinition = dagEngine.getDefinition(jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return wfDefinition;
    }

    private String getBundleJobDefinition(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        String bundleDefinition;
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            bundleDefinition = bundleEngine.getDefinition(jobId);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
        return bundleDefinition;
    }

    private String getCoordinatorJobDefinition(HttpServletRequest request, HttpServletResponse response) throws XServletException {
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        String coordDefinition = null;
        try {
            coordDefinition = coordEngine.getDefinition(jobId);
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
        return coordDefinition;
    }

    private void streamWorkflowJobLog(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            dagEngine.streamLog(jobId, response.getWriter());
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void streamBundleJob(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        try {
            bundleEngine.streamLog(jobId, response.getWriter());
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
    }

    private void streamCoordinatorJobLog(HttpServletRequest request, HttpServletResponse response) throws XServletException, IOException {
        CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request), this.getAuthToken(request));
        String jobId = this.getResourceName(request);
        String logRetrievalScope = request.getParameter("scope");
        String logRetrievalType = request.getParameter("type");
        try {
            coordEngine.streamLog(jobId, logRetrievalScope, logRetrievalType, response.getWriter());
        }
        catch (BaseEngineException ex) {
            throw new XServletException(400, ex);
        }
        catch (CommandException ex) {
            throw new XServletException(400, ex);
        }
    }
}

