/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.BundleEngine;
import org.apache.oozie.BundleEngineException;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.BundleJobInfo;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorEngineException;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.CoordinatorJobInfo;
import org.apache.oozie.DagEngine;
import org.apache.oozie.DagEngineException;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.WorkflowsInfo;
import org.apache.oozie.client.rest.JsonTags;
import org.apache.oozie.service.BundleEngineService;
import org.apache.oozie.service.CoordinatorEngineService;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.BaseJobsServlet;
import org.apache.oozie.servlet.ServletUtilities;
import org.apache.oozie.servlet.XServletException;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XmlUtils;
import org.json.simple.JSONObject;

public class V1JobsServlet
extends BaseJobsServlet {
    private static final String INSTRUMENTATION_NAME = "v1jobs";

    public V1JobsServlet() {
        super(INSTRUMENTATION_NAME);
    }

    @Override
    protected JSONObject submitJob(HttpServletRequest request, Configuration conf) throws XServletException, IOException {
        JSONObject json = null;
        String jobType = request.getParameter("jobtype");
        if (jobType == null) {
            String wfPath = conf.get("oozie.wf.application.path");
            String coordPath = conf.get("oozie.coord.application.path");
            String bundlePath = conf.get("oozie.bundle.application.path");
            ServletUtilities.ValidateAppPath(wfPath, coordPath, bundlePath);
            json = wfPath != null ? this.submitWorkflowJob(request, conf) : (coordPath != null ? this.submitCoordinatorJob(request, conf) : this.submitBundleJob(request, conf));
        } else if (jobType.equals("pig") || jobType.equals("mapreduce")) {
            json = this.submitHttpJob(request, conf, jobType);
        } else {
            throw new XServletException(400, ErrorCode.E0303, "jobtype", jobType);
        }
        return json;
    }

    @Override
    protected JSONObject getJobIdForExternalId(HttpServletRequest request, String externalId) throws XServletException, IOException {
        JSONObject json = null;
        String jobtype = request.getParameter("jobtype");
        jobtype = jobtype != null ? jobtype : "wf";
        json = jobtype.contains("wf") ? this.getWorkflowJobIdForExternalId(request, externalId) : this.getCoordinatorJobIdForExternalId(request, externalId);
        return json;
    }

    @Override
    protected JSONObject getJobs(HttpServletRequest request) throws XServletException, IOException {
        JSONObject json = null;
        String jobtype = request.getParameter("jobtype");
        String string = jobtype = jobtype != null ? jobtype : "wf";
        if (jobtype.contains("wf")) {
            json = this.getWorkflowJobs(request);
        } else if (jobtype.contains("coord")) {
            json = this.getCoordinatorJobs(request);
        } else if (jobtype.contains("bundle")) {
            json = this.getBundleJobs(request);
        }
        return json;
    }

    private JSONObject submitWorkflowJob(HttpServletRequest request, Configuration conf) throws XServletException {
        JSONObject json = new JSONObject();
        try {
            String action = request.getParameter("action");
            if (action != null && !action.equals("start")) {
                throw new XServletException(400, ErrorCode.E0303, "action", action);
            }
            boolean startJob = action != null;
            String user = conf.get("user.name");
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(user, this.getAuthToken(request));
            String id = dagEngine.submitJob(conf, startJob);
            json.put((Object)"id", (Object)id);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject submitCoordinatorJob(HttpServletRequest request, Configuration conf) throws XServletException {
        JSONObject json = new JSONObject();
        XLog.getLog(((Object)((Object)this)).getClass()).warn("submitCoordinatorJob " + XmlUtils.prettyPrint(conf).toString());
        try {
            String action = request.getParameter("action");
            if (action != null && !action.equals("start") && !action.equals("dryrun")) {
                throw new XServletException(400, ErrorCode.E0303, "action", action);
            }
            boolean startJob = action != null;
            String user = conf.get("user.name");
            CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(user, this.getAuthToken(request));
            String id = null;
            boolean dryrun = false;
            if (action != null) {
                dryrun = action.equals("dryrun");
            }
            id = dryrun ? coordEngine.dryrunSubmit(conf, startJob) : coordEngine.submitJob(conf, startJob);
            json.put((Object)"id", (Object)id);
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject submitBundleJob(HttpServletRequest request, Configuration conf) throws XServletException {
        JSONObject json = new JSONObject();
        XLog.getLog(((Object)((Object)this)).getClass()).warn("submitBundleJob " + XmlUtils.prettyPrint(conf).toString());
        try {
            String action = request.getParameter("action");
            if (action != null && !action.equals("start") && !action.equals("dryrun")) {
                throw new XServletException(400, ErrorCode.E0303, "action", action);
            }
            boolean startJob = action != null;
            String user = conf.get("user.name");
            BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(user, this.getAuthToken(request));
            String id = null;
            boolean dryrun = false;
            if (action != null) {
                dryrun = action.equals("dryrun");
            }
            id = dryrun ? bundleEngine.dryrunSubmit(conf, startJob) : bundleEngine.submitJob(conf, startJob);
            json.put((Object)"id", (Object)id);
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject getWorkflowJobIdForExternalId(HttpServletRequest request, String externalId) throws XServletException {
        JSONObject json = new JSONObject();
        try {
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
            String jobId = dagEngine.getJobIdForExternalId(externalId);
            json.put((Object)"id", (Object)jobId);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject getCoordinatorJobIdForExternalId(HttpServletRequest request, String externalId) throws XServletException {
        JSONObject json = new JSONObject();
        return json;
    }

    private JSONObject getWorkflowJobs(HttpServletRequest request) throws XServletException {
        JSONObject json = new JSONObject();
        try {
            String filter = request.getParameter("filter");
            String startStr = request.getParameter("offset");
            String lenStr = request.getParameter("len");
            int start = startStr != null ? Integer.parseInt(startStr) : 1;
            start = start < 1 ? 1 : start;
            int len = lenStr != null ? Integer.parseInt(lenStr) : 50;
            len = len < 1 ? 50 : len;
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(this.getUser(request), this.getAuthToken(request));
            WorkflowsInfo jobs = dagEngine.getJobs(filter, start, len);
            List<WorkflowJobBean> jsonWorkflows = jobs.getWorkflows();
            json.put((Object)"workflows", (Object)WorkflowJobBean.toJSONArray(jsonWorkflows));
            json.put((Object)"total", (Object)jobs.getTotal());
            json.put((Object)"offset", (Object)jobs.getStart());
            json.put((Object)"len", (Object)jobs.getLen());
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject getCoordinatorJobs(HttpServletRequest request) throws XServletException {
        JSONObject json = new JSONObject();
        try {
            String filter = request.getParameter("filter");
            String startStr = request.getParameter("offset");
            String lenStr = request.getParameter("len");
            int start = startStr != null ? Integer.parseInt(startStr) : 1;
            start = start < 1 ? 1 : start;
            int len = lenStr != null ? Integer.parseInt(lenStr) : 50;
            len = len < 1 ? 50 : len;
            CoordinatorEngine coordEngine = Services.get().get(CoordinatorEngineService.class).getCoordinatorEngine(this.getUser(request), this.getAuthToken(request));
            CoordinatorJobInfo jobs = coordEngine.getCoordJobs(filter, start, len);
            List<CoordinatorJobBean> jsonJobs = jobs.getCoordJobs();
            json.put(JsonTags.COORDINATOR_JOBS, (Object)CoordinatorJobBean.toJSONArray(jsonJobs));
            json.put(JsonTags.COORD_JOB_TOTAL, (Object)jobs.getTotal());
            json.put(JsonTags.COORD_JOB_OFFSET, (Object)jobs.getStart());
            json.put(JsonTags.COORD_JOB_LEN, (Object)jobs.getLen());
        }
        catch (CoordinatorEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject getBundleJobs(HttpServletRequest request) throws XServletException {
        JSONObject json = new JSONObject();
        try {
            String filter = request.getParameter("filter");
            String startStr = request.getParameter("offset");
            String lenStr = request.getParameter("len");
            int start = startStr != null ? Integer.parseInt(startStr) : 1;
            start = start < 1 ? 1 : start;
            int len = lenStr != null ? Integer.parseInt(lenStr) : 50;
            len = len < 1 ? 50 : len;
            BundleEngine bundleEngine = Services.get().get(BundleEngineService.class).getBundleEngine(this.getUser(request), this.getAuthToken(request));
            BundleJobInfo jobs = bundleEngine.getBundleJobs(filter, start, len);
            List<BundleJobBean> jsonJobs = jobs.getBundleJobs();
            json.put(JsonTags.BUNDLE_JOBS, (Object)BundleJobBean.toJSONArray(jsonJobs));
            json.put(JsonTags.BUNDLE_JOB_TOTAL, (Object)jobs.getTotal());
            json.put(JsonTags.BUNDLE_JOB_OFFSET, (Object)jobs.getStart());
            json.put(JsonTags.BUNDLE_JOB_LEN, (Object)jobs.getLen());
        }
        catch (BundleEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }

    private JSONObject submitHttpJob(HttpServletRequest request, Configuration conf, String jobType) throws XServletException {
        JSONObject json = new JSONObject();
        try {
            String user = conf.get("user.name");
            DagEngine dagEngine = Services.get().get(DagEngineService.class).getDagEngine(user, this.getAuthToken(request));
            String id = dagEngine.submitHttpJob(conf, jobType);
            json.put((Object)"id", (Object)id);
        }
        catch (DagEngineException ex) {
            throw new XServletException(400, ex);
        }
        return json;
    }
}

