/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.XLogReader;

public class XLogStreamer {
    private String logFile;
    private String logPath;
    private Filter logFilter;
    private Writer logWriter;
    private long logRotation;

    public XLogStreamer(Filter logFilter, Writer logWriter, String logPath, String logFile, long logRotationSecs) {
        this.logWriter = logWriter;
        this.logFilter = logFilter;
        if (logFile == null) {
            logFile = "oozie-app.log";
        }
        this.logFile = logFile;
        this.logPath = logPath;
        this.logRotation = logRotationSecs * 1000L;
    }

    public void streamLog(Date startTime, Date endTime) throws IOException {
        long startTimeMillis = 0L;
        if (startTime != null) {
            startTimeMillis = startTime.getTime();
        }
        long endTimeMillis = endTime == null ? System.currentTimeMillis() : endTime.getTime();
        File dir = new File(this.logPath);
        ArrayList<FileInfo> fileList = this.getFileList(dir, startTimeMillis, endTimeMillis, this.logRotation, this.logFile);
        for (int i = 0; i < fileList.size(); ++i) {
            XLogReader logReader;
            String fileName = fileList.get(i).getFileName();
            if (fileName.endsWith(".gz")) {
                File file = new File(fileName);
                GZIPInputStream gzipInputStream = null;
                gzipInputStream = new GZIPInputStream(new FileInputStream(file));
                logReader = new XLogReader(gzipInputStream, this.logFilter, this.logWriter);
                logReader.processLog();
                logReader.close();
                continue;
            }
            FileInputStream ifs = new FileInputStream(fileName);
            logReader = new XLogReader(ifs, this.logFilter, this.logWriter);
            logReader.processLog();
            ((InputStream)ifs).close();
        }
    }

    private ArrayList<FileInfo> getFileList(File dir, long startTime, long endTime, long logRotationTime, String logFile) {
        String[] children = dir.list();
        ArrayList<FileInfo> fileList = new ArrayList<FileInfo>();
        if (children == null) {
            return fileList;
        }
        for (int i = 0; i < children.length; ++i) {
            String fileName = children[i];
            if (!fileName.startsWith(logFile) && !fileName.equals(logFile)) continue;
            File file = new File(dir.getAbsolutePath(), fileName);
            if (fileName.endsWith(".gz")) {
                long gzFileCreationTime = this.getGZFileCreationTime(fileName, startTime, endTime);
                if (gzFileCreationTime == -1L) continue;
                fileList.add(new FileInfo(file.getAbsolutePath(), gzFileCreationTime));
                continue;
            }
            long modTime = file.lastModified();
            if (modTime < startTime || modTime / logRotationTime > endTime / logRotationTime + 1L) continue;
            fileList.add(new FileInfo(file.getAbsolutePath(), modTime));
        }
        Collections.sort(fileList);
        return fileList;
    }

    private long getGZFileCreationTime(String fileName, long startTime, long endTime) {
        long returnVal = -1L;
        int dateStartIndex = 10;
        String[] dateDetails = fileName.substring(dateStartIndex, fileName.length() - 3).split("-");
        int year = Integer.parseInt(dateDetails[0]);
        int month = Integer.parseInt(dateDetails[1]);
        int day = Integer.parseInt(dateDetails[2]);
        int hour = Integer.parseInt(dateDetails[3]);
        int minute = 0;
        Calendar calendarEntry = Calendar.getInstance();
        calendarEntry.set(year, month - 1, day, hour, minute);
        long logFileStartTime = calendarEntry.getTimeInMillis();
        long milliSecondsPerHour = 3600000L;
        long logFileEndTime = logFileStartTime + milliSecondsPerHour;
        if (startTime >= logFileStartTime && startTime <= logFileEndTime || endTime >= logFileStartTime && endTime <= logFileEndTime) {
            returnVal = logFileStartTime;
        }
        return returnVal;
    }

    class FileInfo
    implements Comparable<FileInfo> {
        String fileName;
        long modTime;

        public FileInfo(String fileName, long modTime) {
            this.fileName = fileName;
            this.modTime = modTime;
        }

        public String getFileName() {
            return this.fileName;
        }

        public long getModTime() {
            return this.modTime;
        }

        @Override
        public int compareTo(FileInfo fileInfo) {
            long diff = this.modTime - fileInfo.modTime;
            if (diff > 0L) {
                return 1;
            }
            if (diff < 0L) {
                return -1;
            }
            return 0;
        }
    }

    public static class Filter {
        private Map<String, Integer> logLevels;
        private Map<String, String> filterParams = new HashMap<String, String>();
        private static List<String> parameters = new ArrayList<String>();
        private boolean noFilter;
        private Pattern filterPattern;
        private static final String DEFAULT_REGEX = "[^\\]]*";
        public static final String ALLOW_ALL_REGEX = "(.*)";
        private static final String TIMESTAMP_REGEX = "(\\d\\d\\d\\d-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d)";
        private static final String WHITE_SPACE_REGEX = "\\s+";
        private static final String LOG_LEVEL_REGEX = "(\\w+)";
        private static final String PREFIX_REGEX = "(\\d\\d\\d\\d-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d)\\s+(\\w+)\\s+";
        private static final Pattern SPLITTER_PATTERN = Pattern.compile("(\\d\\d\\d\\d-\\d\\d-\\d\\d \\d\\d:\\d\\d:\\d\\d,\\d\\d\\d)\\s+(\\w+)\\s+(.*)");

        public Filter() {
            for (int i = 0; i < parameters.size(); ++i) {
                this.filterParams.put(parameters.get(i), DEFAULT_REGEX);
            }
            this.logLevels = null;
            this.noFilter = true;
            this.filterPattern = null;
        }

        public void setLogLevel(String logLevel) {
            if (logLevel != null && logLevel.trim().length() > 0) {
                this.logLevels = new HashMap<String, Integer>();
                String[] levels = logLevel.split("\\|");
                for (int i = 0; i < levels.length; ++i) {
                    String s = levels[i].trim().toUpperCase();
                    try {
                        XLog.Level.valueOf(s);
                    }
                    catch (Exception ex) {
                        continue;
                    }
                    this.logLevels.put(levels[i].toUpperCase(), 1);
                }
            }
        }

        public void setParameter(String filterParam, String value) {
            if (this.filterParams.containsKey(filterParam)) {
                this.noFilter = false;
                this.filterParams.put(filterParam, value);
            }
        }

        public static void defineParameter(String filterParam) {
            parameters.add(filterParam);
        }

        public boolean isFilterPresent() {
            return !this.noFilter || this.logLevels != null;
        }

        public boolean matches(ArrayList<String> logParts) {
            String logLevel = logParts.get(0);
            String logMessage = logParts.get(1);
            if (this.logLevels == null || this.logLevels.containsKey(logLevel.toUpperCase())) {
                Matcher logMatcher = this.filterPattern.matcher(logMessage);
                return logMatcher.matches();
            }
            return false;
        }

        public ArrayList<String> splitLogMessage(String logLine) {
            Matcher splitter = SPLITTER_PATTERN.matcher(logLine);
            if (splitter.matches()) {
                ArrayList<String> logParts = new ArrayList<String>();
                logParts.add(splitter.group(2));
                logParts.add(splitter.group(3));
                return logParts;
            }
            return null;
        }

        public void constructPattern() {
            if (this.noFilter && this.logLevels == null) {
                this.filterPattern = Pattern.compile(ALLOW_ALL_REGEX);
                return;
            }
            StringBuilder sb = new StringBuilder();
            if (this.noFilter) {
                sb.append(ALLOW_ALL_REGEX);
            } else {
                sb.append("(.* - ");
                for (int i = 0; i < parameters.size(); ++i) {
                    sb.append(parameters.get(i) + "\\[");
                    sb.append(this.filterParams.get(parameters.get(i)) + "\\] ");
                }
                sb.append(".*)");
            }
            this.filterPattern = Pattern.compile(sb.toString());
        }

        public static void reset() {
            parameters.clear();
        }
    }
}

