/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.fs;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FilterFileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.wal.DefaultWALProvider;
import org.apache.hadoop.hdfs.DFSClient;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.protocol.ClientProtocol;
import org.apache.hadoop.hdfs.protocol.DatanodeInfo;
import org.apache.hadoop.hdfs.protocol.LocatedBlock;
import org.apache.hadoop.hdfs.protocol.LocatedBlocks;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.ReflectionUtils;

public class HFileSystem
extends FilterFileSystem {
    public static final Log LOG = LogFactory.getLog(HFileSystem.class);
    public static final String HBASE_WAL_DIR = "hbase.wal.dir";
    private final FileSystem noChecksumFs;
    private final boolean useHBaseChecksum;

    public HFileSystem(Configuration conf, boolean useHBaseChecksum) throws IOException {
        this.fs = FileSystem.get((Configuration)conf);
        this.useHBaseChecksum = useHBaseChecksum;
        this.fs.initialize(HFileSystem.getDefaultUri((Configuration)conf), conf);
        if (this.fs instanceof LocalFileSystem) {
            this.fs.setWriteChecksum(false);
            this.fs.setVerifyChecksum(false);
        }
        HFileSystem.addLocationsOrderInterceptor(conf);
        if (useHBaseChecksum && !(this.fs instanceof LocalFileSystem)) {
            conf = new Configuration(conf);
            conf.setBoolean("dfs.client.read.shortcircuit.skip.checksum", true);
            this.noChecksumFs = HFileSystem.newInstanceFileSystem(conf);
            this.noChecksumFs.setVerifyChecksum(false);
        } else {
            this.noChecksumFs = this.fs;
        }
    }

    public HFileSystem(FileSystem fs) {
        this.fs = fs;
        this.noChecksumFs = fs;
        this.useHBaseChecksum = false;
    }

    public FileSystem getNoChecksumFs() {
        return this.noChecksumFs;
    }

    public FileSystem getBackingFs() throws IOException {
        return this.fs;
    }

    public boolean useHBaseChecksum() {
        return this.useHBaseChecksum;
    }

    public void close() throws IOException {
        super.close();
        if (this.noChecksumFs != this.fs) {
            this.noChecksumFs.close();
        }
    }

    private static FileSystem newInstanceFileSystem(Configuration conf) throws IOException {
        URI uri = FileSystem.getDefaultUri((Configuration)conf);
        FileSystem fs = null;
        Class clazz = conf.getClass("fs." + uri.getScheme() + ".impl", null);
        if (clazz != null) {
            fs = (FileSystem)ReflectionUtils.newInstance((Class)clazz, (Configuration)conf);
            fs.initialize(uri, conf);
        } else {
            Configuration clone = new Configuration(conf);
            clone.setBoolean("fs." + uri.getScheme() + ".impl.disable.cache", true);
            fs = FileSystem.get((URI)uri, (Configuration)clone);
        }
        if (fs == null) {
            throw new IOException("No FileSystem for scheme: " + uri.getScheme());
        }
        return fs;
    }

    public static boolean addLocationsOrderInterceptor(Configuration conf) throws IOException {
        return HFileSystem.addLocationsOrderInterceptor(conf, new ReorderWALBlocks());
    }

    static boolean addLocationsOrderInterceptor(Configuration conf, ReorderBlocks lrb) {
        FileSystem fs;
        if (!conf.getBoolean("hbase.filesystem.reorder.blocks", true)) {
            LOG.debug((Object)"addLocationsOrderInterceptor configured to false");
            return false;
        }
        try {
            fs = FileSystem.get((Configuration)conf);
        }
        catch (IOException e) {
            LOG.warn((Object)"Can't get the file system from the conf.", (Throwable)e);
            return false;
        }
        if (!(fs instanceof DistributedFileSystem)) {
            LOG.debug((Object)"The file system is not a DistributedFileSystem. Skipping on block location reordering");
            return false;
        }
        DistributedFileSystem dfs = (DistributedFileSystem)fs;
        DFSClient dfsc = dfs.getClient();
        if (dfsc == null) {
            LOG.warn((Object)"The DistributedFileSystem does not contain a DFSClient. Can't add the location block reordering interceptor. Continuing, but this is unexpected.");
            return false;
        }
        try {
            Field nf = DFSClient.class.getDeclaredField("namenode");
            nf.setAccessible(true);
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(nf, nf.getModifiers() & 0xFFFFFFEF);
            ClientProtocol namenode = (ClientProtocol)nf.get(dfsc);
            if (namenode == null) {
                LOG.warn((Object)"The DFSClient is not linked to a namenode. Can't add the location block reordering interceptor. Continuing, but this is unexpected.");
                return false;
            }
            ClientProtocol cp1 = HFileSystem.createReorderingProxy(namenode, lrb, conf);
            nf.set(dfsc, cp1);
            LOG.info((Object)("Added intercepting call to namenode#getBlockLocations so can do block reordering using class " + lrb.getClass()));
        }
        catch (NoSuchFieldException e) {
            LOG.warn((Object)"Can't modify the DFSClient#namenode field to add the location reorder.", (Throwable)e);
            return false;
        }
        catch (IllegalAccessException e) {
            LOG.warn((Object)"Can't modify the DFSClient#namenode field to add the location reorder.", (Throwable)e);
            return false;
        }
        return true;
    }

    private static ClientProtocol createReorderingProxy(final ClientProtocol cp, final ReorderBlocks lrb, final Configuration conf) {
        return (ClientProtocol)Proxy.newProxyInstance(cp.getClass().getClassLoader(), new Class[]{ClientProtocol.class, Closeable.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    if ((args == null || args.length == 0) && "close".equals(method.getName())) {
                        RPC.stopProxy((Object)cp);
                        return null;
                    }
                    Object res = method.invoke((Object)cp, args);
                    if (res != null && args != null && args.length == 3 && "getBlockLocations".equals(method.getName()) && res instanceof LocatedBlocks && args[0] instanceof String && args[0] != null) {
                        lrb.reorderBlocks(conf, (LocatedBlocks)res, (String)args[0]);
                    }
                    return res;
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getCause();
                    if (cause == null) {
                        throw new RuntimeException("Proxy invocation failed and getCause is null", ite);
                    }
                    if (cause instanceof UndeclaredThrowableException) {
                        Throwable causeCause = cause.getCause();
                        if (causeCause == null) {
                            throw new RuntimeException("UndeclaredThrowableException had null cause!");
                        }
                        cause = cause.getCause();
                    }
                    throw cause;
                }
            }
        });
    }

    public static FileSystem get(Configuration conf) throws IOException {
        return new HFileSystem(conf, true);
    }

    public static FileSystem getLocalFs(Configuration conf) throws IOException {
        return new HFileSystem((FileSystem)FileSystem.getLocal((Configuration)conf));
    }

    public FSDataOutputStream createNonRecursive(Path f, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        return this.fs.createNonRecursive(f, overwrite, bufferSize, replication, blockSize, progress);
    }

    static class ReorderWALBlocks
    implements ReorderBlocks {
        ReorderWALBlocks() {
        }

        @Override
        public void reorderBlocks(Configuration conf, LocatedBlocks lbs, String src) throws IOException {
            ServerName sn = DefaultWALProvider.getServerNameFromWALDirectoryName(conf, src);
            if (sn == null) {
                return;
            }
            String hostName = sn.getHostname();
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(src + " is an WAL file, so reordering blocks, last hostname will be:" + hostName));
            }
            for (LocatedBlock lb : lbs.getLocatedBlocks()) {
                DatanodeInfo[] dnis = lb.getLocations();
                if (dnis == null || dnis.length <= 1) continue;
                boolean found = false;
                for (int i = 0; i < dnis.length - 1 && !found; ++i) {
                    if (!hostName.equals(dnis[i].getHostName())) continue;
                    DatanodeInfo toLast = dnis[i];
                    System.arraycopy(dnis, i + 1, dnis, i, dnis.length - i - 1);
                    dnis[dnis.length - 1] = toLast;
                    found = true;
                }
            }
        }
    }

    static interface ReorderBlocks {
        public void reorderBlocks(Configuration var1, LocatedBlocks var2, String var3) throws IOException;
    }
}

