/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.ScheduledChore;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableDescriptors;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.mob.MobUtils;

@InterfaceAudience.Private
public class MobFileCompactionChore
extends ScheduledChore {
    private static final Log LOG = LogFactory.getLog(MobFileCompactionChore.class);
    private HMaster master;
    private TableLockManager tableLockManager;
    private ExecutorService pool;

    public MobFileCompactionChore(HMaster master) {
        super(master.getServerName() + "-MobFileCompactChore", (Stoppable)master, master.getConfiguration().getInt("hbase.mob.file.compaction.chore.period", 604800000));
        this.master = master;
        this.tableLockManager = master.getTableLockManager();
        this.pool = MobUtils.createMobFileCompactorThreadPool(master.getConfiguration());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void chore() {
        try {
            TableDescriptors htds = this.master.getTableDescriptors();
            Map<String, HTableDescriptor> map = htds.getAll();
            for (HTableDescriptor htd : map.values()) {
                if (!this.master.getConnection().isTableEnabled(htd.getTableName())) continue;
                boolean reported = false;
                try {
                    for (HColumnDescriptor hcd : htd.getColumnFamilies()) {
                        if (!hcd.isMobEnabled()) continue;
                        if (!reported) {
                            this.master.reportMobFileCompactionStart(htd.getTableName());
                            reported = true;
                        }
                        MobUtils.doMobFileCompaction(this.master.getConfiguration(), this.master.getFileSystem(), htd.getTableName(), hcd, this.pool, this.tableLockManager, false);
                    }
                }
                finally {
                    if (!reported) continue;
                    this.master.reportMobFileCompactionEnd(htd.getTableName());
                }
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Fail to clean the expired mob files", (Throwable)e);
        }
    }

    protected void cleanup() {
        super.cleanup();
        this.pool.shutdown();
    }
}

