/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mob.filecompactions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hbase.mob.filecompactions.MobFileCompactionRequest;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class PartitionedMobFileCompactionRequest
extends MobFileCompactionRequest {
    protected Collection<FileStatus> delFiles;
    protected Collection<CompactionPartition> compactionPartitions;

    public PartitionedMobFileCompactionRequest(Collection<CompactionPartition> compactionPartitions, Collection<FileStatus> delFiles) {
        this.selectionTime = EnvironmentEdgeManager.currentTime();
        this.compactionPartitions = compactionPartitions;
        this.delFiles = delFiles;
    }

    public Collection<CompactionPartition> getCompactionPartitions() {
        return this.compactionPartitions;
    }

    public Collection<FileStatus> getDelFiles() {
        return this.delFiles;
    }

    public static class CompactionPartitionId {
        private String startKey;
        private String date;
        private String latestDate;
        private long threshold;

        public CompactionPartitionId() {
            this.startKey = "";
            this.date = "";
            this.latestDate = "";
            this.threshold = 0L;
        }

        public CompactionPartitionId(String startKey, String date) {
            if (startKey == null || date == null) {
                throw new IllegalArgumentException("Neither of start key and date could be null");
            }
            this.startKey = startKey;
            this.date = date;
            this.latestDate = "";
            this.threshold = 0L;
        }

        public void setThreshold(long threshold) {
            this.threshold = threshold;
        }

        public long getThreshold() {
            return this.threshold;
        }

        public String getStartKey() {
            return this.startKey;
        }

        public void setStartKey(String startKey) {
            this.startKey = startKey;
        }

        public String getDate() {
            return this.date;
        }

        public void setDate(String date) {
            this.date = date;
        }

        public String getLatestDate() {
            return this.latestDate;
        }

        public void updateLatestDate(String latestDate) {
            if (this.latestDate.compareTo(latestDate) < 0) {
                this.latestDate = latestDate;
            }
        }

        public int hashCode() {
            int result = 17;
            result = 31 * result + this.startKey.hashCode();
            result = 31 * result + this.date.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CompactionPartitionId)) {
                return false;
            }
            CompactionPartitionId another = (CompactionPartitionId)obj;
            if (!this.startKey.equals(another.startKey)) {
                return false;
            }
            return this.date.equals(another.date);
        }

        public String toString() {
            return this.startKey + this.date;
        }
    }

    protected static class CompactionPartition {
        private List<FileStatus> files = new ArrayList<FileStatus>();
        private CompactionPartitionId partitionId;

        public CompactionPartition(CompactionPartitionId partitionId) {
            this.partitionId = partitionId;
        }

        public CompactionPartitionId getPartitionId() {
            return this.partitionId;
        }

        public void addFile(FileStatus file) {
            this.files.add(file);
        }

        public List<FileStatus> listFiles() {
            return Collections.unmodifiableList(this.files);
        }

        public int getFileCount() {
            return this.files.size();
        }
    }
}

