/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.regionserver.ChangedReadersObserver;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScan;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.NoLimitScannerContext;
import org.apache.hadoop.hbase.regionserver.NonReversedNonLazyKeyValueScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RowTooBigException;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.handler.ParallelSeekHandler;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;

@InterfaceAudience.Private
public class StoreScanner
extends NonReversedNonLazyKeyValueScanner
implements KeyValueScanner,
InternalScanner,
ChangedReadersObserver {
    private static final Log LOG = LogFactory.getLog(StoreScanner.class);
    protected final Store store;
    protected ScanQueryMatcher matcher;
    protected KeyValueHeap heap;
    protected boolean cacheBlocks;
    protected long countPerRow = 0L;
    protected int storeLimit = -1;
    protected int storeOffset = 0;
    protected boolean closing = false;
    protected final boolean get;
    protected final boolean explicitColumnQuery;
    protected final boolean useRowColBloom;
    protected boolean parallelSeekEnabled = false;
    protected ExecutorService executor;
    protected final Scan scan;
    protected final NavigableSet<byte[]> columns;
    protected final long oldestUnexpiredTS;
    protected final long now;
    protected final int minVersions;
    protected final long maxRowSize;
    protected final long cellsPerHeartbeatCheck;
    private long kvsScanned = 0L;
    private Cell prevCell = null;
    static final boolean LAZY_SEEK_ENABLED_BY_DEFAULT = true;
    public static final String STORESCANNER_PARALLEL_SEEK_ENABLE = "hbase.storescanner.parallel.seek.enable";
    protected static boolean lazySeekEnabledGlobally = true;
    public static final String HBASE_CELLS_SCANNED_PER_HEARTBEAT_CHECK = "hbase.cells.scanned.per.heartbeat.check";
    public static final long DEFAULT_HBASE_CELLS_SCANNED_PER_HEARTBEAT_CHECK = 10000L;
    protected Cell lastTop = null;
    private boolean scanUsePread = false;
    protected ReentrantLock lock = new ReentrantLock();
    protected final long readPt;

    protected StoreScanner(Store store, Scan scan, ScanInfo scanInfo, NavigableSet<byte[]> columns, long readPt, boolean cacheBlocks) {
        RegionServerServices rsService;
        this.readPt = readPt;
        this.store = store;
        this.cacheBlocks = cacheBlocks;
        this.get = scan.isGetScan();
        int numCol = columns == null ? 0 : columns.size();
        this.explicitColumnQuery = numCol > 0;
        this.scan = scan;
        this.columns = columns;
        this.now = EnvironmentEdgeManager.currentTime();
        this.oldestUnexpiredTS = this.now - scanInfo.getTtl();
        this.minVersions = scanInfo.getMinVersions();
        this.useRowColBloom = numCol > 1 || !this.get && numCol == 1;
        this.maxRowSize = scanInfo.getTableMaxRowSize();
        this.scanUsePread = scan.isSmall() ? true : scanInfo.isUsePread();
        this.cellsPerHeartbeatCheck = scanInfo.getCellsPerTimeoutCheck();
        if (this.store != null && this.store.getStorefilesCount() > 1 && (rsService = ((HStore)store).getHRegion().getRegionServerServices()) != null && scanInfo.isParallelSeekEnabled()) {
            this.parallelSeekEnabled = true;
            this.executor = rsService.getExecutorService();
        }
    }

    public StoreScanner(Store store, ScanInfo scanInfo, Scan scan, NavigableSet<byte[]> columns, long readPt) throws IOException {
        this(store, scan, scanInfo, columns, readPt, scan.getCacheBlocks());
        if (columns != null && scan.isRaw()) {
            throw new DoNotRetryIOException("Cannot specify any column for a raw scan");
        }
        this.matcher = new ScanQueryMatcher(scan, scanInfo, columns, ScanType.USER_SCAN, Long.MAX_VALUE, Long.MAX_VALUE, this.oldestUnexpiredTS, this.now, store.getCoprocessorHost());
        this.store.addChangedReaderObserver(this);
        try {
            List<KeyValueScanner> scanners = this.getScannersNoCompaction();
            this.seekScanners(scanners, this.matcher.getStartKey(), this.explicitColumnQuery && lazySeekEnabledGlobally, this.parallelSeekEnabled);
            this.storeLimit = scan.getMaxResultsPerColumnFamily();
            this.storeOffset = scan.getRowOffsetPerColumnFamily();
            this.resetKVHeap(scanners, store.getComparator());
        }
        catch (IOException e) {
            this.store.deleteChangedReaderObserver(this);
            throw e;
        }
    }

    public StoreScanner(Store store, ScanInfo scanInfo, Scan scan, List<? extends KeyValueScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs) throws IOException {
        this(store, scanInfo, scan, scanners, scanType, smallestReadPoint, earliestPutTs, null, null);
    }

    public StoreScanner(Store store, ScanInfo scanInfo, Scan scan, List<? extends KeyValueScanner> scanners, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
        this(store, scanInfo, scan, scanners, ScanType.COMPACT_RETAIN_DELETES, smallestReadPoint, earliestPutTs, dropDeletesFromRow, dropDeletesToRow);
    }

    private StoreScanner(Store store, ScanInfo scanInfo, Scan scan, List<? extends KeyValueScanner> scanners, ScanType scanType, long smallestReadPoint, long earliestPutTs, byte[] dropDeletesFromRow, byte[] dropDeletesToRow) throws IOException {
        this(store, scan, scanInfo, null, ((HStore)store).getHRegion().getReadpoint(IsolationLevel.READ_COMMITTED), false);
        this.matcher = dropDeletesFromRow == null ? new ScanQueryMatcher(scan, scanInfo, null, scanType, smallestReadPoint, earliestPutTs, this.oldestUnexpiredTS, this.now, store.getCoprocessorHost()) : new ScanQueryMatcher(scan, scanInfo, null, smallestReadPoint, earliestPutTs, this.oldestUnexpiredTS, this.now, dropDeletesFromRow, dropDeletesToRow, store.getCoprocessorHost());
        scanners = this.selectScannersFrom(scanners);
        this.seekScanners(scanners, this.matcher.getStartKey(), false, this.parallelSeekEnabled);
        this.resetKVHeap(scanners, store.getComparator());
    }

    @VisibleForTesting
    StoreScanner(Scan scan, ScanInfo scanInfo, ScanType scanType, NavigableSet<byte[]> columns, List<KeyValueScanner> scanners) throws IOException {
        this(scan, scanInfo, scanType, columns, scanners, Long.MAX_VALUE, 0L);
    }

    @VisibleForTesting
    StoreScanner(Scan scan, ScanInfo scanInfo, ScanType scanType, NavigableSet<byte[]> columns, List<KeyValueScanner> scanners, long earliestPutTs) throws IOException {
        this(scan, scanInfo, scanType, columns, scanners, earliestPutTs, 0L);
    }

    public StoreScanner(Scan scan, ScanInfo scanInfo, ScanType scanType, NavigableSet<byte[]> columns, List<KeyValueScanner> scanners, long earliestPutTs, long readPt) throws IOException {
        this(null, scan, scanInfo, columns, readPt, scan.getCacheBlocks());
        this.matcher = new ScanQueryMatcher(scan, scanInfo, columns, scanType, Long.MAX_VALUE, earliestPutTs, this.oldestUnexpiredTS, this.now, null);
        if (this.store != null) {
            this.store.addChangedReaderObserver(this);
        }
        this.seekScanners(scanners, this.matcher.getStartKey(), false, this.parallelSeekEnabled);
        this.resetKVHeap(scanners, scanInfo.getComparator());
    }

    protected List<KeyValueScanner> getScannersNoCompaction() throws IOException {
        boolean isCompaction = false;
        boolean usePread = this.get || this.scanUsePread;
        return this.selectScannersFrom(this.store.getScanners(this.cacheBlocks, this.get, usePread, false, this.matcher, this.scan.getStartRow(), this.scan.getStopRow(), this.readPt));
    }

    protected void seekScanners(List<? extends KeyValueScanner> scanners, Cell seekKey, boolean isLazy, boolean isParallelSeek) throws IOException {
        if (isLazy) {
            for (KeyValueScanner keyValueScanner : scanners) {
                keyValueScanner.requestSeek(seekKey, false, true);
            }
        } else if (!isParallelSeek) {
            long totalScannersSoughtBytes = 0L;
            for (KeyValueScanner keyValueScanner : scanners) {
                if (this.matcher.isUserScan() && totalScannersSoughtBytes >= this.maxRowSize) {
                    throw new RowTooBigException("Max row size allowed: " + this.maxRowSize + ", but row is bigger than that");
                }
                keyValueScanner.seek(seekKey);
                Cell c = keyValueScanner.peek();
                if (c == null) continue;
                totalScannersSoughtBytes += (long)CellUtil.estimatedSerializedSizeOf((Cell)c);
            }
        } else {
            this.parallelSeek(scanners, seekKey);
        }
    }

    protected void resetKVHeap(List<? extends KeyValueScanner> scanners, KeyValue.KVComparator comparator) throws IOException {
        this.heap = new KeyValueHeap(scanners, comparator);
    }

    protected List<KeyValueScanner> selectScannersFrom(List<? extends KeyValueScanner> allScanners) {
        boolean filesOnly;
        boolean memOnly;
        if (this.scan instanceof InternalScan) {
            InternalScan iscan = (InternalScan)this.scan;
            memOnly = iscan.isCheckOnlyMemStore();
            filesOnly = iscan.isCheckOnlyStoreFiles();
        } else {
            memOnly = false;
            filesOnly = false;
        }
        ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>(allScanners.size());
        long expiredTimestampCutoff = this.minVersions == 0 ? this.oldestUnexpiredTS : Long.MIN_VALUE;
        for (KeyValueScanner keyValueScanner : allScanners) {
            boolean isFile = keyValueScanner.isFileScanner();
            if (!isFile && filesOnly || isFile && memOnly || !keyValueScanner.shouldUseScanner(this.scan, this.store, expiredTimestampCutoff)) continue;
            scanners.add(keyValueScanner);
        }
        return scanners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Cell peek() {
        this.lock.lock();
        try {
            if (this.heap == null) {
                Cell cell = this.lastTop;
                return cell;
            }
            Cell cell = this.heap.peek();
            return cell;
        }
        finally {
            this.lock.unlock();
        }
    }

    public KeyValue next() {
        throw new RuntimeException("Never call StoreScanner.next()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.lock.lock();
        try {
            if (this.closing) {
                return;
            }
            this.closing = true;
            if (this.store != null) {
                this.store.deleteChangedReaderObserver(this);
            }
            if (this.heap != null) {
                this.heap.close();
            }
            this.heap = null;
            this.lastTop = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean seek(Cell key) throws IOException {
        this.lock.lock();
        try {
            this.checkReseek();
            boolean bl = this.heap.seek(key);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean next(List<Cell> outResult) throws IOException {
        return this.next(outResult, NoLimitScannerContext.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean next(List<Cell> outResult, ScannerContext scannerContext) throws IOException {
        this.lock.lock();
        try {
            if (scannerContext == null) {
                throw new IllegalArgumentException("Scanner context cannot be null");
            }
            if (this.checkReseek()) {
                boolean bl = scannerContext.setScannerState(ScannerContext.NextState.MORE_VALUES).hasMoreValues();
                return bl;
            }
            if (this.heap == null) {
                this.close();
                boolean bl = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                return bl;
            }
            Cell cell = this.heap.peek();
            if (cell == null) {
                this.close();
                boolean bl = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                return bl;
            }
            byte[] row = cell.getRowArray();
            int offset = cell.getRowOffset();
            short length = cell.getRowLength();
            if (!scannerContext.hasAnyLimit(ScannerContext.LimitScope.BETWEEN_CELLS) || this.matcher.row == null) {
                this.countPerRow = 0L;
                this.matcher.setRow(row, offset, length);
            }
            if (!scannerContext.getKeepProgress()) {
                scannerContext.clearProgress();
            }
            KeyValue.KVComparator comparator = this.store != null ? this.store.getComparator() : null;
            int count = 0;
            long totalBytesRead = 0L;
            block22: do {
                if (this.kvsScanned % this.cellsPerHeartbeatCheck == 0L) {
                    scannerContext.updateTimeProgress();
                    if (scannerContext.checkTimeLimit(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                        boolean bl = scannerContext.setScannerState(ScannerContext.NextState.TIME_LIMIT_REACHED).hasMoreValues();
                        return bl;
                    }
                }
                if (this.prevCell != cell) {
                    ++this.kvsScanned;
                }
                this.checkScanOrder(this.prevCell, cell, comparator);
                this.prevCell = cell;
                ScanQueryMatcher.MatchCode qcode = this.matcher.match(cell);
                qcode = this.optimize(qcode, cell);
                switch (qcode) {
                    case INCLUDE: 
                    case INCLUDE_AND_SEEK_NEXT_ROW: 
                    case INCLUDE_AND_SEEK_NEXT_COL: {
                        Filter f = this.matcher.getFilter();
                        if (f != null) {
                            cell = f.transformCell(cell);
                        }
                        ++this.countPerRow;
                        if (this.storeLimit > -1 && this.countPerRow > (long)(this.storeLimit + this.storeOffset)) {
                            if (!this.matcher.moreRowsMayExistAfter(cell)) {
                                boolean bl = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                                return bl;
                            }
                            this.matcher.row = null;
                            this.seekToNextRow(cell);
                            break block22;
                        }
                        if (this.countPerRow > (long)this.storeOffset) {
                            outResult.add(cell);
                            ++count;
                            scannerContext.incrementSizeProgress(CellUtil.estimatedHeapSizeOfWithoutTags((Cell)cell));
                            scannerContext.incrementBatchProgress(1);
                            if (this.matcher.isUserScan() && (totalBytesRead += (long)CellUtil.estimatedSerializedSizeOf((Cell)cell)) > this.maxRowSize) {
                                throw new RowTooBigException("Max row size allowed: " + this.maxRowSize + ", but the row is bigger than that.");
                            }
                        }
                        if (qcode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_ROW) {
                            if (!this.matcher.moreRowsMayExistAfter(cell)) {
                                boolean bl = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                                return bl;
                            }
                            this.matcher.row = null;
                            this.seekToNextRow(cell);
                        } else if (qcode == ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL) {
                            this.seekAsDirection(this.matcher.getKeyForNextColumn(cell));
                        } else {
                            this.heap.next();
                        }
                        if (!scannerContext.checkBatchLimit(ScannerContext.LimitScope.BETWEEN_CELLS) && !scannerContext.checkSizeLimit(ScannerContext.LimitScope.BETWEEN_CELLS)) continue block22;
                        break block22;
                    }
                    case DONE: {
                        this.matcher.row = null;
                        boolean bl = scannerContext.setScannerState(ScannerContext.NextState.MORE_VALUES).hasMoreValues();
                        return bl;
                    }
                    case DONE_SCAN: {
                        this.close();
                        boolean bl = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                        return bl;
                    }
                    case SEEK_NEXT_ROW: {
                        if (!this.matcher.moreRowsMayExistAfter(cell)) {
                            boolean bl = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                            return bl;
                        }
                        this.matcher.row = null;
                        this.seekToNextRow(cell);
                        break;
                    }
                    case SEEK_NEXT_COL: {
                        this.seekAsDirection(this.matcher.getKeyForNextColumn(cell));
                        break;
                    }
                    case SKIP: {
                        this.heap.next();
                        break;
                    }
                    case SEEK_NEXT_USING_HINT: {
                        Cell nextKV = this.matcher.getNextKeyHint(cell);
                        if (nextKV != null) {
                            this.seekAsDirection(nextKV);
                            break;
                        }
                        this.heap.next();
                        break;
                    }
                    default: {
                        throw new RuntimeException("UNEXPECTED");
                    }
                }
            } while ((cell = this.heap.peek()) != null);
            if (count > 0) {
                boolean bl = scannerContext.setScannerState(ScannerContext.NextState.MORE_VALUES).hasMoreValues();
                return bl;
            }
            this.close();
            boolean bl = scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    private ScanQueryMatcher.MatchCode optimize(ScanQueryMatcher.MatchCode qcode, Cell cell) {
        switch (qcode) {
            case INCLUDE_AND_SEEK_NEXT_COL: 
            case SEEK_NEXT_COL: {
                Cell nextIndexedKey = this.getNextIndexedKey();
                if (nextIndexedKey == null || nextIndexedKey == KeyValueScanner.NO_NEXT_INDEXED_KEY || this.matcher.compareKeyForNextColumn(nextIndexedKey, cell) < 0) break;
                return qcode == ScanQueryMatcher.MatchCode.SEEK_NEXT_COL ? ScanQueryMatcher.MatchCode.SKIP : ScanQueryMatcher.MatchCode.INCLUDE;
            }
            case INCLUDE_AND_SEEK_NEXT_ROW: 
            case SEEK_NEXT_ROW: {
                Cell nextIndexedKey = this.getNextIndexedKey();
                if (nextIndexedKey == null || nextIndexedKey == KeyValueScanner.NO_NEXT_INDEXED_KEY || this.matcher.compareKeyForNextRow(nextIndexedKey, cell) < 0) break;
                return qcode == ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW ? ScanQueryMatcher.MatchCode.SKIP : ScanQueryMatcher.MatchCode.INCLUDE;
            }
        }
        return qcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateReaders() throws IOException {
        this.lock.lock();
        try {
            if (this.closing) {
                return;
            }
            if (this.heap == null) {
                return;
            }
            this.lastTop = this.peek();
            this.heap.close();
            this.heap = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected boolean checkReseek() throws IOException {
        if (this.heap == null && this.lastTop != null) {
            this.resetScannerStack(this.lastTop);
            if (this.heap.peek() == null || this.store.getComparator().compareRows(this.lastTop, this.heap.peek()) != 0) {
                LOG.debug((Object)("Storescanner.peek() is changed where before = " + this.lastTop.toString() + ",and after = " + this.heap.peek()));
                this.lastTop = null;
                return true;
            }
            this.lastTop = null;
        }
        return false;
    }

    protected void resetScannerStack(Cell lastTopKey) throws IOException {
        if (this.heap != null) {
            throw new RuntimeException("StoreScanner.reseek run on an existing heap!");
        }
        List<KeyValueScanner> scanners = this.getScannersNoCompaction();
        this.seekScanners(scanners, lastTopKey, false, this.parallelSeekEnabled);
        this.resetKVHeap(scanners, this.store.getComparator());
        Cell kv = this.heap.peek();
        if (kv == null) {
            kv = lastTopKey;
        }
        byte[] row = kv.getRowArray();
        int offset = kv.getRowOffset();
        short length = kv.getRowLength();
        if (this.matcher.row == null || !Bytes.equals((byte[])row, (int)offset, (int)length, (byte[])this.matcher.row, (int)this.matcher.rowOffset, (int)this.matcher.rowLength)) {
            this.countPerRow = 0L;
            this.matcher.reset();
            this.matcher.setRow(row, offset, length);
        }
    }

    protected void checkScanOrder(Cell prevKV, Cell kv, KeyValue.KVComparator comparator) throws IOException {
        assert (prevKV == null || comparator == null || comparator.compare(prevKV, kv) <= 0) : "Key " + prevKV + " followed by a " + "smaller key " + kv + " in cf " + this.store;
    }

    protected boolean seekToNextRow(Cell kv) throws IOException {
        return this.reseek((Cell)KeyValueUtil.createLastOnRow((Cell)kv));
    }

    protected boolean seekAsDirection(Cell kv) throws IOException {
        return this.reseek(kv);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean reseek(Cell kv) throws IOException {
        this.lock.lock();
        try {
            this.checkReseek();
            if (this.explicitColumnQuery && lazySeekEnabledGlobally) {
                boolean bl = this.heap.requestSeek(kv, true, this.useRowColBloom);
                return bl;
            }
            boolean bl = this.heap.reseek(kv);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public long getScannerOrder() {
        return 0L;
    }

    private void parallelSeek(List<? extends KeyValueScanner> scanners, Cell kv) throws IOException {
        if (scanners.isEmpty()) {
            return;
        }
        int storeFileScannerCount = scanners.size();
        CountDownLatch latch = new CountDownLatch(storeFileScannerCount);
        ArrayList<ParallelSeekHandler> handlers = new ArrayList<ParallelSeekHandler>(storeFileScannerCount);
        for (KeyValueScanner keyValueScanner : scanners) {
            if (keyValueScanner instanceof StoreFileScanner) {
                ParallelSeekHandler seekHandler = new ParallelSeekHandler(keyValueScanner, kv, this.readPt, latch);
                this.executor.submit(seekHandler);
                handlers.add(seekHandler);
                continue;
            }
            keyValueScanner.seek(kv);
            latch.countDown();
        }
        try {
            latch.await();
        }
        catch (InterruptedException ie) {
            throw (InterruptedIOException)new InterruptedIOException().initCause(ie);
        }
        for (ParallelSeekHandler parallelSeekHandler : handlers) {
            if (parallelSeekHandler.getErr() == null) continue;
            throw new IOException(parallelSeekHandler.getErr());
        }
    }

    List<KeyValueScanner> getAllScannersForTesting() {
        ArrayList<KeyValueScanner> allScanners = new ArrayList<KeyValueScanner>();
        KeyValueScanner current = this.heap.getCurrentForTesting();
        if (current != null) {
            allScanners.add(current);
        }
        for (KeyValueScanner scanner : this.heap.getHeap()) {
            allScanners.add(scanner);
        }
        return allScanners;
    }

    static void enableLazySeekGlobally(boolean enable) {
        lazySeekEnabledGlobally = enable;
    }

    public long getEstimatedNumberOfKvsScanned() {
        return this.kvsScanned;
    }

    @Override
    public Cell getNextIndexedKey() {
        return this.heap.getNextIndexedKey();
    }

    static enum StoreScannerCompactionRace {
        BEFORE_SEEK,
        AFTER_SEEK,
        COMPACT_COMPLETE;

    }
}

