/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.web.extender.war.internal;

import org.ops4j.lang.NullArgumentException;
import org.ops4j.pax.web.extender.war.internal.UnregisterWebAppVisitorWC;
import org.ops4j.pax.web.extender.war.internal.WebAppVisitor;
import org.ops4j.pax.web.extender.war.internal.model.WebApp;
import org.ops4j.pax.web.extender.war.internal.model.WebAppConstraintMapping;
import org.ops4j.pax.web.extender.war.internal.model.WebAppErrorPage;
import org.ops4j.pax.web.extender.war.internal.model.WebAppFilter;
import org.ops4j.pax.web.extender.war.internal.model.WebAppListener;
import org.ops4j.pax.web.extender.war.internal.model.WebAppLoginConfig;
import org.ops4j.pax.web.extender.war.internal.model.WebAppServlet;
import org.osgi.service.http.HttpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UnregisterWebAppVisitorHS
implements WebAppVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(UnregisterWebAppVisitorWC.class);
    private final HttpService httpService;

    UnregisterWebAppVisitorHS(HttpService httpService) {
        NullArgumentException.validateNotNull(httpService, "Http Service");
        this.httpService = httpService;
    }

    @Override
    public void visit(WebApp webApp) {
        try {
            this.httpService.unregister("/");
        }
        catch (Exception ignore) {
            LOG.error("Unregistration exception. Skipping.", (Throwable)ignore);
        }
    }

    @Override
    public void visit(WebAppServlet webAppServlet) {
        NullArgumentException.validateNotNull(webAppServlet, "Web app servlet");
        String[] aliases = webAppServlet.getAliases();
        if (aliases != null && aliases.length > 0) {
            for (String alias : aliases) {
                try {
                    this.httpService.unregister(alias);
                }
                catch (Exception ignore) {
                    LOG.error("Unregistration exception. Skipping.", (Throwable)ignore);
                }
            }
        } else {
            LOG.warn("Servlet [" + webAppServlet + "] does not have any alias. Skipped.");
        }
    }

    @Override
    public void visit(WebAppFilter webAppFilter) {
        LOG.info("Pax Web not available. Skipping filter unregistration for [" + webAppFilter + "]");
    }

    @Override
    public void visit(WebAppListener webAppListener) {
        LOG.info("Pax Web not available. Skipping listener unregistration for [" + webAppListener + "]");
    }

    @Override
    public void visit(WebAppErrorPage webAppErrorPage) {
        LOG.info("Pax Web not available. Skipping error page unregistration for [" + webAppErrorPage + "]");
    }

    @Override
    public void visit(WebAppLoginConfig loginConfig) {
        LOG.info("Pax Web not available. Skipping login config unregistration for [" + loginConfig + "]");
    }

    @Override
    public void visit(WebAppConstraintMapping constraintMapping) {
        LOG.info("Pax Web not available. Skipping constraint mapping unregistration for [" + constraintMapping + "]");
    }

    @Override
    public void end() {
    }
}

