/*
 * Decompiled with CFR 0.152.
 */
package org.apache.connectors.td.types;

import org.apache.connectors.td.types.HiveDataType;

public enum TeradataDataType {
    BIGINT(-5, HiveDataType.INT),
    BINARY(-2, HiveDataType.BINARY),
    BIT(-7, HiveDataType.BOOLEAN),
    BLOB(2004, HiveDataType.BINARY),
    BOOLEAN(16, HiveDataType.BOOLEAN),
    CHAR(1, HiveDataType.STRING),
    CLOB(2005, HiveDataType.STRING),
    DATE(91, HiveDataType.DATE),
    DECIMAL(3, HiveDataType.DECIMAL),
    DOUBLE(8, HiveDataType.DOUBLE),
    FLOAT(6, HiveDataType.FLOAT),
    INTEGER(4, HiveDataType.INT),
    LONGNVARCHAR(-16, HiveDataType.STRING),
    LONGVARBINARY(-4, HiveDataType.BINARY),
    LONGVARCHAR(-1, HiveDataType.STRING),
    NUMERIC(2, HiveDataType.FLOAT),
    REAL(7, HiveDataType.FLOAT),
    SMALLINT(5, HiveDataType.SMALLINT),
    TIMESTAMP(93, HiveDataType.TIMESTAMP),
    TINYINT(-6, HiveDataType.TINYINT),
    VARCHAR(12, HiveDataType.STRING),
    VARBYTE(-3, HiveDataType.STRING);

    private int typeID;
    private HiveDataType mappedType;

    private TeradataDataType(int type, HiveDataType mappedType) {
        this.mappedType = mappedType;
        this.typeID = type;
    }

    public boolean matchesTypeID(int type) {
        return type == this.typeID;
    }

    public static TeradataDataType find(int typeID) {
        for (TeradataDataType t : TeradataDataType.values()) {
            if (!t.matchesTypeID(typeID)) continue;
            return t;
        }
        return null;
    }

    public HiveDataType getHiveDataType() {
        return this.mappedType;
    }
}

