/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.actionsequence.dom;

import org.dom4j.Document;
import org.dom4j.Element;
import org.pentaho.actionsequence.dom.ActionSequenceDocument;
import org.pentaho.actionsequence.dom.ActionSequenceOutput;
import org.pentaho.actionsequence.dom.IActionSequenceOutput;
import org.pentaho.actionsequence.dom.IActionSequenceOutputDestination;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;

public class ActionSequenceOutputDestination
implements IActionSequenceOutputDestination {
    Element destinationElement;
    IActionParameterMgr actionInputProvider;

    protected ActionSequenceOutputDestination(Element element, IActionParameterMgr actionInputProvider) {
        this.destinationElement = element;
        this.actionInputProvider = actionInputProvider;
    }

    @Override
    public void setDestination(String destination) {
        this.destinationElement.setName(destination);
        ActionSequenceDocument.fireIoChanged(this.getActionSequenceOutput());
    }

    @Override
    public String getDestination() {
        return this.destinationElement.getName();
    }

    @Override
    public void setName(String name) {
        this.destinationElement.setText(name);
        ActionSequenceDocument.fireIoChanged(this.getActionSequenceOutput());
    }

    @Override
    public String getName() {
        return this.destinationElement.getText();
    }

    @Override
    public IActionSequenceOutput getActionSequenceOutput() {
        Element ancestorElement;
        ActionSequenceOutput actionSequenceOutput = null;
        if (this.destinationElement != null && (ancestorElement = this.destinationElement.getParent()) != null && (ancestorElement = ancestorElement.getParent()) != null) {
            actionSequenceOutput = new ActionSequenceOutput(ancestorElement, this.actionInputProvider);
        }
        return actionSequenceOutput;
    }

    @Override
    public void delete() {
        Document doc = this.destinationElement.getDocument();
        if (doc != null) {
            IActionSequenceOutput actionSequenceOutput = this.getActionSequenceOutput();
            this.destinationElement.detach();
            ActionSequenceDocument.fireIoChanged(actionSequenceOutput);
        }
    }
}

