/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import org.pentaho.di.engine.model.Configurable;
import org.pentaho.di.engine.model.Hop;
import org.pentaho.di.engine.model.Operation;

public class Transformation
extends Configurable
implements org.pentaho.di.engine.api.model.Transformation {
    private static final long serialVersionUID = -4909410400954814057L;
    private final String id;
    private final LinkedList<org.pentaho.di.engine.api.model.Operation> operations = new LinkedList();
    private final LinkedList<org.pentaho.di.engine.api.model.Hop> hops = new LinkedList();

    public Transformation(String id) {
        this.id = id;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public List<org.pentaho.di.engine.api.model.Operation> getOperations() {
        return ImmutableList.copyOf(this.operations);
    }

    private ImmutableList<org.pentaho.di.engine.api.model.Operation> filterOperations(Predicate<org.pentaho.di.engine.api.model.Operation> filter) {
        ImmutableList.Builder builder = ImmutableList.builder();
        this.operations.stream().filter(filter).forEach(arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Override
    public List<org.pentaho.di.engine.api.model.Hop> getHops() {
        return this.hops;
    }

    public String toString() {
        return "Transformation{id='" + this.id + "'}";
    }

    public Operation createOperation(String id) {
        Operation operation = new Operation(id, this);
        this.operations.add(operation);
        return operation;
    }

    public Hop createHop(org.pentaho.di.engine.api.model.Operation from, org.pentaho.di.engine.api.model.Operation to) {
        return this.createHop(from, to, "NORMAL");
    }

    public Hop createHop(org.pentaho.di.engine.api.model.Operation from, org.pentaho.di.engine.api.model.Operation to, String type) {
        Preconditions.checkArgument((boolean)this.operations.contains(from), (Object)"!operations.contains(from)");
        Preconditions.checkArgument((boolean)this.operations.contains(to), (Object)"!operations.contains(to)");
        Preconditions.checkArgument((from != to ? 1 : 0) != 0, (Object)"from == to");
        Hop hop = new Hop(from, to, type);
        Preconditions.checkState((boolean)this.hops.stream().noneMatch(it -> it.getFrom() == from && it.getTo() == to), (String)"Hop from %s to %s already exists", (Object[])new Object[]{from, to});
        this.hops.add(hop);
        return hop;
    }
}

