/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sqoop.lib;

import com.cloudera.sqoop.lib.BlobRef;
import com.cloudera.sqoop.lib.ClobRef;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.hadoop.io.BytesWritable;

public final class JdbcWritableBridge {
    public static final long MAX_BLOB_LENGTH = 0x1000000L;
    public static final long MAX_CLOB_LENGTH = 0x1000000L;

    private JdbcWritableBridge() {
    }

    public static Integer readInteger(int colNum, ResultSet r) throws SQLException {
        int val = r.getInt(colNum);
        if (r.wasNull()) {
            return null;
        }
        return val;
    }

    public static Long readLong(int colNum, ResultSet r) throws SQLException {
        long val = r.getLong(colNum);
        if (r.wasNull()) {
            return null;
        }
        return val;
    }

    public static String readString(int colNum, ResultSet r) throws SQLException {
        return r.getString(colNum);
    }

    public static Float readFloat(int colNum, ResultSet r) throws SQLException {
        float val = r.getFloat(colNum);
        if (r.wasNull()) {
            return null;
        }
        return Float.valueOf(val);
    }

    public static Double readDouble(int colNum, ResultSet r) throws SQLException {
        double val = r.getDouble(colNum);
        if (r.wasNull()) {
            return null;
        }
        return val;
    }

    public static Boolean readBoolean(int colNum, ResultSet r) throws SQLException {
        boolean val = r.getBoolean(colNum);
        if (r.wasNull()) {
            return null;
        }
        return val;
    }

    public static Time readTime(int colNum, ResultSet r) throws SQLException {
        return r.getTime(colNum);
    }

    public static Timestamp readTimestamp(int colNum, ResultSet r) throws SQLException {
        return r.getTimestamp(colNum);
    }

    public static Date readDate(int colNum, ResultSet r) throws SQLException {
        return r.getDate(colNum);
    }

    public static BytesWritable readBytesWritable(int colNum, ResultSet r) throws SQLException {
        byte[] bytes = r.getBytes(colNum);
        return bytes == null ? null : new BytesWritable(bytes);
    }

    public static BigDecimal readBigDecimal(int colNum, ResultSet r) throws SQLException {
        return r.getBigDecimal(colNum);
    }

    public static BlobRef readBlobRef(int colNum, ResultSet r) throws SQLException {
        return null;
    }

    public static ClobRef readClobRef(int colNum, ResultSet r) throws SQLException {
        return null;
    }

    public static void writeInteger(Integer val, int paramIdx, int sqlType, PreparedStatement s) throws SQLException {
        if (null == val) {
            s.setNull(paramIdx, sqlType);
        } else {
            s.setInt(paramIdx, val);
        }
    }

    public static void writeLong(Long val, int paramIdx, int sqlType, PreparedStatement s) throws SQLException {
        if (null == val) {
            s.setNull(paramIdx, sqlType);
        } else {
            s.setLong(paramIdx, val);
        }
    }

    public static void writeDouble(Double val, int paramIdx, int sqlType, PreparedStatement s) throws SQLException {
        if (null == val) {
            s.setNull(paramIdx, sqlType);
        } else {
            s.setDouble(paramIdx, val);
        }
    }

    public static void writeBoolean(Boolean val, int paramIdx, int sqlType, PreparedStatement s) throws SQLException {
        if (null == val) {
            s.setNull(paramIdx, sqlType);
        } else {
            s.setBoolean(paramIdx, val);
        }
    }

    public static void writeFloat(Float val, int paramIdx, int sqlType, PreparedStatement s) throws SQLException {
        if (null == val) {
            s.setNull(paramIdx, sqlType);
        } else {
            s.setFloat(paramIdx, val.floatValue());
        }
    }

    public static void writeString(String val, int paramIdx, int sqlType, PreparedStatement s) throws SQLException {
        if (null == val) {
            s.setNull(paramIdx, sqlType);
        } else {
            s.setString(paramIdx, val);
        }
    }

    public static void writeTimestamp(Timestamp val, int paramIdx, int sqlType, PreparedStatement s) throws SQLException {
        if (null == val) {
            s.setNull(paramIdx, sqlType);
        } else {
            s.setTimestamp(paramIdx, val);
        }
    }

    public static void writeTime(Time val, int paramIdx, int sqlType, PreparedStatement s) throws SQLException {
        if (null == val) {
            s.setNull(paramIdx, sqlType);
        } else {
            s.setTime(paramIdx, val);
        }
    }

    public static void writeDate(Date val, int paramIdx, int sqlType, PreparedStatement s) throws SQLException {
        if (null == val) {
            s.setNull(paramIdx, sqlType);
        } else {
            s.setDate(paramIdx, val);
        }
    }

    public static void writeBytesWritable(BytesWritable val, int paramIdx, int sqlType, PreparedStatement s) throws SQLException {
        if (null == val) {
            s.setNull(paramIdx, sqlType);
        } else {
            byte[] rawBytes = val.getBytes();
            int len = val.getLength();
            byte[] outBytes = new byte[len];
            System.arraycopy(rawBytes, 0, outBytes, 0, len);
            s.setBytes(paramIdx, outBytes);
        }
    }

    public static void writeBigDecimal(BigDecimal val, int paramIdx, int sqlType, PreparedStatement s) throws SQLException {
        if (null == val) {
            s.setNull(paramIdx, sqlType);
        } else {
            s.setBigDecimal(paramIdx, val);
        }
    }

    public static void writeBlobRef(BlobRef val, int paramIdx, int sqlType, PreparedStatement s) throws SQLException {
        throw new RuntimeException("Unsupported: Cannot export BLOB data");
    }

    public static void writeClobRef(ClobRef val, int paramIdx, int sqlType, PreparedStatement s) throws SQLException {
        throw new RuntimeException("Unsupported: Cannot export CLOB data");
    }
}

