/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.engine.security.SecurityHelper;
import pt.webdetails.cpf.AbstractCpfProperties;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IReadAccess;

public class CpfProperties
extends AbstractCpfProperties {
    private static final long serialVersionUID = 1L;
    private static CpfProperties instance;
    private static final Log logger;

    private CpfProperties(IContentAccessFactory accessor) {
        super(accessor);
    }

    public static CpfProperties getInstance() {
        if (instance == null) {
            instance = new CpfProperties(PluginEnvironment.repository());
        }
        return instance;
    }

    @Override
    protected boolean loadAsSystem(final IReadAccess inRepositoryCpf) {
        try {
            return (Boolean)SecurityHelper.getInstance().runAsSystem((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return CpfProperties.this.loadProperties(inRepositoryCpf, AbstractCpfProperties.PROPERTIES_FILE);
                }
            });
        }
        catch (Exception e) {
            logger.warn((Object)("Couldn't load '" + PROPERTIES_FILE + "' as system"), (Throwable)e);
            return false;
        }
    }

    static {
        logger = LogFactory.getLog(CpfProperties.class);
    }
}

