/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpf.InterPluginCall;
import pt.webdetails.cpf.PentahoBasePluginEnvironment;
import pt.webdetails.cpf.PentahoUrlProvider;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.api.IContentAccessFactoryExtended;
import pt.webdetails.cpf.api.IUserContentAccessExtended;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.plugincall.api.IPluginCall;
import pt.webdetails.cpf.repository.api.IRWAccess;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.repository.api.IRepositoryAccessFactory;
import pt.webdetails.cpf.repository.pentaho.unified.UnifiedRepositoryAccessFactory;

public class PentahoPluginEnvironment
extends PentahoBasePluginEnvironment
implements IContentAccessFactoryExtended {
    private static PentahoPluginEnvironment instance = new PentahoPluginEnvironment();
    private IUrlProvider pentahoUrlProvider;
    private static Log logger = LogFactory.getLog(PentahoPluginEnvironment.class);
    private IRepositoryAccessFactory repositoryAccessFactory = new UnifiedRepositoryAccessFactory();

    protected PentahoPluginEnvironment() {
    }

    public static PentahoPluginEnvironment getInstance() {
        return instance;
    }

    public IContentAccessFactoryExtended getContentAccessFactory() {
        return this;
    }

    public IUserContentAccessExtended getUserContentAccess(String basePath) {
        return this.repositoryAccessFactory.getUserContentAccess(basePath);
    }

    public IReadAccess getPluginRepositoryReader(String basePath) {
        return this.repositoryAccessFactory.getPluginRepositoryReader(this.getPluginRepositoryDir(), basePath);
    }

    public IRWAccess getPluginRepositoryWriter(String basePath) {
        return this.repositoryAccessFactory.getPluginRepositoryWriter(this.getPluginRepositoryDir(), basePath);
    }

    public IUrlProvider getUrlProvider() {
        if (this.pentahoUrlProvider == null) {
            this.pentahoUrlProvider = new PentahoUrlProvider(this.getPluginId());
        }
        return this.pentahoUrlProvider;
    }

    public IPluginCall getPluginCall(String pluginId, String servicePath, String method) {
        return new InterPluginCall(new InterPluginCall.Plugin(pluginId), servicePath, method);
    }

    public void setRepositoryAccessFactory(IRepositoryAccessFactory factory) {
        this.repositoryAccessFactory = factory;
    }

    static {
        PluginEnvironment.init((PluginEnvironment)instance);
    }
}

