/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import pt.webdetails.cpf.messaging.JsonSerializable;

public class Result
implements JsonSerializable {
    private static Log logger = LogFactory.getLog(Result.class);
    private JSONObject json;

    public Result() {
    }

    public Result(Status status, Object result) {
        this.json = new JSONObject();
        try {
            this.json.put("status", (Object)status.toString());
            if (result != null && result instanceof JsonSerializable) {
                this.json.put("result", (Object)((JsonSerializable)result).toJSON());
            } else {
                this.json.put("result", result);
            }
        }
        catch (JSONException e) {
            logger.error((Object)"Error writing JSON", (Throwable)e);
        }
    }

    public Result(JSONObject json) {
        this.json = json;
    }

    public Status getStatus() {
        try {
            return Status.valueOf(this.json.getString("status"));
        }
        catch (Exception e) {
            return Status.ERROR;
        }
    }

    public static Result getFromException(Exception e) {
        String msg = e.getLocalizedMessage();
        if (StringUtils.isEmpty((String)msg) && StringUtils.isEmpty((String)(msg = e.getMessage()))) {
            msg = e.getClass().getName();
        }
        return Result.getError(msg);
    }

    public static Result getOK(Object result) {
        return new Result(Status.OK, result);
    }

    public static Result getError(String msg) {
        return new Result(Status.ERROR, msg);
    }

    public String toString() {
        return this.json != null ? this.json.toString() : "null";
    }

    public JSONObject toJSON() throws JSONException {
        return this.json;
    }

    public static enum Status {
        OK,
        ERROR;

    }
}

