/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.messaging;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.web.CpfHttpServletRequest;

public class MockHttpServletRequest
extends CpfHttpServletRequest
implements HttpServletRequest {
    protected Map<String, String[]> parameters;
    protected String pathInfo;
    protected String method = "GET";

    public MockHttpServletRequest(String path, Map<String, String[]> requestParameters) {
        this.pathInfo = path;
        this.parameters = requestParameters;
        this.setParameterMap(this.parameters);
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getPathInfo() {
        return this.pathInfo;
    }

    @Override
    public String getServletPath() {
        return "/plugin";
    }

    @Override
    public String getContextPath() {
        return StringUtils.removeEnd((String)PentahoRequestContextHolder.getRequestContext().getContextPath(), (String)"/");
    }

    @Override
    public String getRequestURI() {
        return Util.joinPath((String[])new String[]{this.getContextPath(), this.getServletPath(), this.getPathInfo()});
    }

    @Override
    public String getQueryString() {
        if (this.parameters == null || this.parameters.size() < 1) {
            return "";
        }
        StringBuilder qb = new StringBuilder();
        boolean isFirst = true;
        for (String key : this.parameters.keySet()) {
            for (String value : this.parameters.get(key)) {
                if (!isFirst) {
                    qb.append("&");
                } else {
                    isFirst = false;
                }
                qb.append(Util.urlEncode((String)key));
                qb.append('=');
                qb.append(Util.urlEncode((String)value));
            }
        }
        return qb.toString();
    }

    @Override
    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    @Override
    public String getParameter(String name) {
        String[] paramValue = this.parameters.get(name);
        if (paramValue != null && paramValue.length > 0) {
            return paramValue[0];
        }
        return null;
    }

    @Override
    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    @Override
    public Map<String, String[]> getParameterMap() {
        return Collections.unmodifiableMap(this.parameters);
    }
}

