/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.olap;

import java.util.List;
import javax.sql.DataSource;
import mondrian.olap.Connection;
import mondrian.olap.Dimension;
import mondrian.olap.DriverManager;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.Query;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapMemberBase;
import mondrian.rolap.RolapResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogHelper;

public abstract class AbstractOlapUtils {
    protected static Log logger = LogFactory.getLog(AbstractOlapUtils.class);
    protected IPentahoSession userSession;
    protected final IMondrianCatalogService mondrianCatalogService = this.getMondrianCatalogService();
    Connection nativeConnection = null;
    private static final String DIRECTION_DOWN = "down";

    public AbstractOlapUtils() {
        this.userSession = PentahoSessionHolder.getSession();
    }

    public JSONObject getOlapCubes() throws JSONException {
        logger.debug((Object)"Returning Olap cubes");
        JSONObject result = new JSONObject();
        JSONArray catalogsArray = new JSONArray();
        List<MondrianCatalog> catalogList = this.getMondrianCatalogs();
        for (MondrianCatalog catalog : catalogList) {
            JSONObject catalogJson = new JSONObject();
            catalogJson.put("name", (Object)catalog.getName());
            catalogJson.put("schema", (Object)catalog.getDefinition());
            catalogJson.put("jndi", (Object)this.getJndiFromCatalog(catalog));
            catalogJson.put("cubes", (Object)this.createJsonArrayFromCollection(catalog.getSchema().getCubes()));
            catalogsArray.put((Object)catalogJson);
        }
        logger.debug((Object)("Cubes found: " + catalogsArray.toString(2)));
        result.put("catalogs", (Object)catalogsArray);
        return result;
    }

    private JSONArray createJsonArrayFromCollection(List objects) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (Object obj : objects) {
            jsonArray.put((Object)new JSONObject(obj));
        }
        return jsonArray;
    }

    public JSONObject getCubeStructure(String catalog, String cube, String jndi) throws JSONException {
        Connection connection;
        logger.debug((Object)("Returning Olap structure for cube " + cube));
        JSONObject result = new JSONObject();
        Connection connection2 = connection = jndi != null ? this.getMdxConnection(catalog, jndi) : this.getMdxConnection(catalog);
        if (connection == null) {
            logger.error((Object)"Failed to get valid connection");
            return null;
        }
        JSONArray dimensionsArray = this.getDimensions(connection, cube);
        System.out.println(dimensionsArray.toString(2));
        result.put("dimensions", (Object)dimensionsArray);
        JSONArray measuresArray = this.getMeasures(connection, cube);
        System.out.println(measuresArray.toString(2));
        result.put("measures", (Object)measuresArray);
        return result;
    }

    private JSONArray getDimensions(Connection connection, String cube) throws JSONException {
        String query = "select {} ON Rows,  {} ON Columns from [" + cube + "]";
        Query mdxQuery = connection.parseQuery(query);
        Dimension[] dimensions = mdxQuery.getCube().getDimensions();
        JSONArray dimensionsArray = new JSONArray();
        for (Dimension dimension : dimensions) {
            Hierarchy[] hierarchies;
            if (dimension.isMeasures()) continue;
            JSONObject jsonDimension = new JSONObject();
            jsonDimension.put("name", (Object)dimension.getName());
            jsonDimension.put("caption", (Object)(dimension.getCaption().isEmpty() ? dimension.getName() : dimension.getCaption()));
            jsonDimension.put("type", (Object)dimension.getDimensionType().name());
            JSONArray hierarchiesArray = new JSONArray();
            for (Hierarchy hierarchy : hierarchies = dimension.getHierarchies()) {
                Level[] levels;
                JSONObject jsonHierarchy = new JSONObject();
                jsonHierarchy.put("type", (Object)"hierarchy");
                jsonHierarchy.put("name", (Object)hierarchy.getName());
                jsonHierarchy.put("caption", (Object)(hierarchy.getCaption().isEmpty() ? hierarchy.getName() : hierarchy.getCaption()));
                jsonHierarchy.put("qualifiedName", (Object)hierarchy.getQualifiedName().substring(11, hierarchy.getQualifiedName().length() - 1));
                jsonHierarchy.put("defaultMember", (Object)hierarchy.getAllMember().getName());
                jsonHierarchy.put("defaultMemberQualifiedName", (Object)hierarchy.getAllMember().getQualifiedName().substring(8, hierarchy.getAllMember().getQualifiedName().length() - 1));
                JSONArray levelsArray = new JSONArray();
                for (Level level : levels = hierarchy.getLevels()) {
                    JSONObject jsonLevel = new JSONObject();
                    if (level.isAll()) continue;
                    jsonLevel.put("type", (Object)"level");
                    jsonLevel.put("depth", level.getDepth());
                    jsonLevel.put("name", (Object)level.getName());
                    jsonLevel.put("caption", (Object)(level.getCaption().isEmpty() ? level.getName() : level.getCaption()));
                    jsonLevel.put("qualifiedName", (Object)level.getQualifiedName().substring(7, level.getQualifiedName().length() - 1));
                    levelsArray.put((Object)jsonLevel);
                }
                jsonHierarchy.put("levels", (Object)levelsArray);
                hierarchiesArray.put((Object)jsonHierarchy);
            }
            jsonDimension.put("hierarchies", (Object)hierarchiesArray);
            dimensionsArray.put((Object)jsonDimension);
        }
        return dimensionsArray;
    }

    public JSONArray getMeasures(Connection connection, String cube) throws JSONException {
        String query = "select {Measures.Children} ON Rows,  {} ON Columns from [" + cube + "]";
        Query mdxQuery = connection.parseQuery(query);
        RolapResult result = (RolapResult)connection.execute(mdxQuery);
        List<RolapMember> rolapMembers = this.getMeasuresMembersFromResult(result);
        JSONArray measuresArray = new JSONArray();
        for (RolapMember measure : rolapMembers) {
            JSONObject jsonMeasure = new JSONObject();
            jsonMeasure.put("type", (Object)"measure");
            jsonMeasure.put("name", (Object)((RolapMemberBase)measure).getName());
            jsonMeasure.put("caption", (Object)(((RolapMemberBase)measure).getCaption().isEmpty() ? ((RolapMemberBase)measure).getName() : ((RolapMemberBase)measure).getCaption()));
            jsonMeasure.put("qualifiedName", (Object)measure.getQualifiedName().substring(8, measure.getQualifiedName().length() - 1));
            jsonMeasure.put("memberType", (Object)measure.getMemberType().toString());
            measuresArray.put((Object)jsonMeasure);
        }
        return measuresArray;
    }

    protected Connection getMdxConnection(String catalog) {
        MondrianCatalog selectedCatalog;
        if (catalog != null && catalog.startsWith("/")) {
            catalog = StringUtils.substring((String)catalog, (int)1);
        }
        if ((selectedCatalog = this.mondrianCatalogService.getCatalog(catalog, this.userSession)) == null) {
            logger.error((Object)("Received catalog '" + catalog + "' doesn't appear to be valid"));
            return null;
        }
        selectedCatalog.getDataSourceInfo();
        logger.info((Object)("Found catalog " + selectedCatalog.toString()));
        String connectStr = "provider=mondrian;dataSource=" + this.getJndiFromCatalog(selectedCatalog) + "; Catalog=" + selectedCatalog.getDefinition();
        return this.getMdxConnectionFromConnectionString(connectStr);
    }

    private Connection getMdxConnection(String catalog, String jndi) {
        String connectStr = "provider=mondrian;dataSource=" + jndi + "; Catalog=" + catalog;
        return this.getMdxConnectionFromConnectionString(connectStr);
    }

    protected Connection getMdxConnectionFromConnectionString(String connectStr) {
        Util.PropertyList properties = Util.parseConnectString((String)connectStr);
        try {
            String dataSourceName = properties.get(RolapConnectionProperties.DataSource.name());
            if (dataSourceName != null) {
                DataSource dataSourceImpl = this.getDatasourceImpl(dataSourceName);
                if (dataSourceImpl != null) {
                    properties.remove(RolapConnectionProperties.DataSource.name());
                    this.nativeConnection = DriverManager.getConnection((Util.PropertyList)properties, null, (DataSource)dataSourceImpl);
                } else {
                    this.nativeConnection = DriverManager.getConnection((Util.PropertyList)properties, null);
                }
            } else {
                this.nativeConnection = DriverManager.getConnection((Util.PropertyList)properties, null);
            }
            if (this.nativeConnection == null) {
                logger.error((Object)("Invalid connection: " + connectStr));
            }
        }
        catch (Throwable t) {
            logger.error((Object)("Invalid connection: " + connectStr + " - " + t.toString()));
        }
        return this.nativeConnection;
    }

    public List<MondrianCatalog> getMondrianCatalogs() {
        return this.mondrianCatalogService.listCatalogs(this.userSession, true);
    }

    public JSONObject getLevelMembersStructure(String catalog, String cube, String memberString, String direction) throws JSONException {
        Connection connection = this.getMdxConnection(catalog);
        String query = "";
        query = direction.equals(DIRECTION_DOWN) ? "select " + memberString + ".children on Rows, {} ON Columns from [" + cube + "]" : "select " + memberString + ".parent.parent.children on Rows, {} ON Columns from [" + cube + "]";
        Query mdxQuery = connection.parseQuery(query);
        RolapResult result = (RolapResult)connection.execute(mdxQuery);
        List positions = result.getAxes()[1].getPositions();
        JSONArray membersArray = new JSONArray();
        for (Position position : positions) {
            Member member = (Member)position.get(0);
            JSONObject jsonMeasure = new JSONObject();
            jsonMeasure.put("type", (Object)"member");
            jsonMeasure.put("name", (Object)member.getName());
            jsonMeasure.put("caption", (Object)(member.getCaption().isEmpty() ? member.getName() : member.getCaption()));
            jsonMeasure.put("qualifiedName", (Object)member.getQualifiedName().substring(8, member.getQualifiedName().length() - 1));
            jsonMeasure.put("memberType", (Object)member.getMemberType().toString());
            membersArray.put((Object)jsonMeasure);
        }
        JSONObject output = new JSONObject();
        output.put("members", (Object)membersArray);
        return output;
    }

    public JSONObject getPaginatedLevelMembers(String catalog, String cube, String level, String startMember, String context, String searchTerm, long pageSize, long pageStart) throws JSONException {
        boolean hasFilter;
        Connection connection = this.getMdxConnection(catalog);
        boolean hasStartMember = true;
        boolean bl = hasFilter = !searchTerm.equals("");
        if (startMember == null || startMember.equals("")) {
            hasStartMember = false;
            startMember = level + ".Hierarchy.defaultMember";
        }
        String query = "with set descendantsSet as Descendants(" + startMember + " , " + level + ") set membersSet as " + level + ".Members set resultSet as " + (hasStartMember ? "descendantsSet" : "membersSet") + " set filteredSet as filter(resultSet, " + level + ".hierarchy.currentMember.name MATCHES '(?i).*" + searchTerm + ".*' ) select {} ON COLUMNS,  Subset(Order( " + (hasFilter ? "filteredSet " : "resultSet ") + ", " + level + ".hierarchy.currentMember.Name,BASC), " + pageStart + ", " + (pageSize + 1L) + ") ON ROWS from [" + cube + "] where {" + context + "}";
        Query mdxQuery = connection.parseQuery(query);
        RolapResult result = (RolapResult)connection.execute(mdxQuery);
        List positions = result.getAxes()[1].getPositions();
        boolean nextPage = (long)positions.size() == pageSize + 1L;
        JSONArray membersArray = new JSONArray();
        int i = 0;
        for (Position position : positions) {
            if ((long)i++ == pageSize) break;
            Member member = (Member)position.get(0);
            JSONObject jsonMeasure = new JSONObject();
            jsonMeasure.put("type", (Object)"member");
            jsonMeasure.put("name", (Object)member.getName());
            jsonMeasure.put("caption", (Object)(member.getCaption() != null ? member.getCaption() : member.getName()));
            jsonMeasure.put("qualifiedName", (Object)member.getQualifiedName().substring(8, member.getQualifiedName().length() - 1));
            jsonMeasure.put("memberType", (Object)member.getMemberType().toString());
            membersArray.put((Object)jsonMeasure);
        }
        JSONObject output = new JSONObject();
        output.put("members", (Object)membersArray);
        output.put("more", nextPage);
        return output;
    }

    protected IMondrianCatalogService getMondrianCatalogService() {
        return MondrianCatalogHelper.getInstance();
    }

    protected List<RolapMember> getMeasuresMembersFromResult(RolapResult result) {
        return result.getCube().getMeasuresMembers();
    }

    protected abstract String getJndiFromCatalog(MondrianCatalog var1);

    protected abstract DataSource getDatasourceImpl(String var1) throws Exception;
}

