/*
 * Decompiled with CFR 0.152.
 */
package pt.webdetails.cpf.web;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import pt.webdetails.cpf.web.CpfHttpServletResponse;

class CpfRequestDispatcher
implements RequestDispatcher {
    private final String url;
    private final Log logger = LogFactory.getLog(this.getClass());

    public CpfRequestDispatcher(String url) {
        this.url = url;
    }

    public void forward(ServletRequest request, ServletResponse response) {
        if (response.isCommitted()) {
            throw new IllegalStateException("Cannot perform forward - response is already committed");
        }
        if (!(response instanceof CpfHttpServletResponse)) {
            throw new IllegalArgumentException("CpfRequestDispatcher requires CpfHttpServletResponse");
        }
        ((CpfHttpServletResponse)response).setForwardedUrl(this.url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("CpfRequestDispatcher: forwarding to URL [" + this.url + "]"));
        }
    }

    public void include(ServletRequest request, ServletResponse response) {
        if (!(response instanceof CpfHttpServletResponse)) {
            throw new IllegalArgumentException("CpfRequestDispatcher requires CpfHttpServletResponse");
        }
        ((CpfHttpServletResponse)response).setIncludedUrl(this.url);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("CpfRequestDispatcher: including URL [" + this.url + "]"));
        }
    }
}

