/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.cdf.CdfApi;
import org.pentaho.cdf.Messages;
import org.pentaho.cdf.context.ContextEngine;
import org.pentaho.cdf.environment.CdfEngine;
import org.pentaho.cdf.render.CdfHtmlRenderer;
import org.pentaho.cdf.render.XcdfRenderer;
import org.pentaho.cdf.util.Parameter;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import pt.webdetails.cpf.SimpleContentGenerator;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.audit.CpfAuditHelper;
import pt.webdetails.cpf.utils.CharsetHelper;

public class CdfContentGenerator
extends SimpleContentGenerator {
    private static final long serialVersionUID = 319509966121604058L;
    private static final Log logger = LogFactory.getLog(CdfContentGenerator.class);
    private static final String PLUGIN_ID = CdfEngine.getEnvironment().getPluginId();
    public String RELATIVE_URL;
    private boolean cdfResource;

    public void createContent() throws Exception {
        String filePath = "";
        String template = "";
        boolean loadTheme = false;
        logger.info((Object)("[Timing] CDF content generator took over: " + new SimpleDateFormat("HH:mm:ss.SSS").format(new Date())));
        try {
            if (this.getPathParameters() != null) {
                if (this.isCdfResource()) {
                    new CdfApi().getResource(this.getPathParameterAsString("cmd", null), null, this.getResponse());
                    return;
                }
                filePath = this.getPathParameterAsString("path", null);
                template = this.getRequestParameterAsString("template", null);
                loadTheme = new Boolean(this.getRequestParameterAsString("loadTheme", "false"));
                HttpServletRequest parameter = this.getRequest();
                if (parameter != null && parameter.getContextPath() != null) {
                    this.RELATIVE_URL = parameter.getContextPath();
                }
            } else {
                Object context;
                Method getContextPath;
                this.RELATIVE_URL = CdfEngine.getEnvironment().getApplicationBaseUrl();
                if (("".equals(this.RELATIVE_URL) || this.RELATIVE_URL.matches("^http://.*")) && (getContextPath = (context = PentahoSystem.getApplicationContext().getContext()).getClass().getMethod("getContextPath", null)) != null) {
                    this.RELATIVE_URL = getContextPath.invoke(context, null).toString();
                }
            }
            if (this.RELATIVE_URL.endsWith("/")) {
                this.RELATIVE_URL = this.RELATIVE_URL.substring(0, this.RELATIVE_URL.length() - 1);
            }
            OutputStream out = this.getResponseOutputStream("text/html");
            if (this.callbacks != null && this.callbacks.size() > 0 && HashMap.class.isInstance(this.callbacks.get(0))) {
                HashMap iface = (HashMap)this.callbacks.get(0);
                out = (OutputStream)iface.get("output");
                filePath = "/" + (String)iface.get("method");
                IPentahoSession iPentahoSession = this.userSession = this.userSession != null ? this.userSession : (IPentahoSession)iface.get("usersession");
            }
            if (this.outputHandler == null) {
                this.error(Messages.getErrorString((String)"CdfContentGenerator.ERROR_0001_NO_OUTPUT_HANDLER"));
                throw new InvalidParameterException(Messages.getString((String)"CdfContentGenerator.ERROR_0001_NO_OUTPUT_HANDLER"));
            }
            if (out == null) {
                this.error(Messages.getErrorString((String)"CdfContentGenerator.ERROR_0003_NO_OUTPUT_STREAM"));
                throw new InvalidParameterException(Messages.getString((String)"CdfContentGenerator.ERROR_0003_NO_OUTPUT_STREAM"));
            }
            if (filePath.isEmpty()) {
                logger.error((Object)"Calling cdf with an empty method");
            }
            if (this.getRequestParameters() != null) {
                this.renderXcdfDashboard(out, this.getRequestParameters(), FilenameUtils.separatorsToUnix((String)filePath), template, loadTheme);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Error creating cdf content: ", (Throwable)e);
        }
    }

    public void renderXcdfDashboard(OutputStream out, IParameterProvider requestParams, String xcdfFilePath, String defaultTemplate, boolean loadTheme) throws Exception {
        long start = System.currentTimeMillis();
        UUID uuid = CpfAuditHelper.startAudit((String)PLUGIN_ID, (String)xcdfFilePath, (String)this.getObjectName(), (IPentahoSession)this.userSession, (ILogger)this, (IParameterProvider)requestParams);
        try {
            boolean success;
            XcdfRenderer renderer = new XcdfRenderer();
            boolean bl = success = renderer.determineDashboardTemplating(xcdfFilePath, defaultTemplate) && renderer.determineRequireDashboard(xcdfFilePath);
            if (success) {
                String templatePath = Util.joinPath((String[])new String[]{FilenameUtils.getPath((String)xcdfFilePath), renderer.getTemplate()});
                if (!StringUtils.isEmpty((String)defaultTemplate)) {
                    this.renderHtmlDashboard(out, xcdfFilePath, templatePath, defaultTemplate, renderer.getMessagesBaseFilename(), renderer.getIsRequire(), loadTheme);
                } else {
                    this.renderHtmlDashboard(out, xcdfFilePath, templatePath, renderer.getStyle(), renderer.getMessagesBaseFilename(), renderer.getIsRequire(), loadTheme);
                }
                this.setResponseHeaders("text/html", 0, null);
            } else {
                out.write("Unable to render dashboard".getBytes(CharsetHelper.getEncoding()));
            }
            long end = System.currentTimeMillis();
            CpfAuditHelper.endAudit((String)PLUGIN_ID, (String)xcdfFilePath, (String)this.getObjectName(), (IPentahoSession)this.userSession, (ILogger)this, (long)start, (UUID)uuid, (long)end);
        }
        catch (Exception e) {
            e.printStackTrace();
            long end = System.currentTimeMillis();
            CpfAuditHelper.endAudit((String)PLUGIN_ID, (String)xcdfFilePath, (String)this.getObjectName(), (IPentahoSession)this.userSession, (ILogger)this, (long)start, (UUID)uuid, (long)end);
            throw e;
        }
    }

    public void renderHtmlDashboard(OutputStream out, String xcdfFilePath, String templatePath, String defaultTemplate, String dashboardsMessagesBaseFilename) throws Exception {
        this.renderHtmlDashboard(out, xcdfFilePath, templatePath, defaultTemplate, dashboardsMessagesBaseFilename, false, false);
    }

    public void renderHtmlDashboard(OutputStream out, String xcdfFilePath, String templatePath, String defaultTemplate, String dashboardsMessagesBaseFilename, boolean isRequire, boolean loadTheme) throws Exception {
        HttpServletRequest request = this.getRequest();
        CdfHtmlRenderer renderer = new CdfHtmlRenderer();
        HashMap<String, String> paramMap = Parameter.asHashMap(request);
        if (paramMap.get("file") == null || paramMap.get("file").isEmpty()) {
            paramMap.put("file", xcdfFilePath);
        }
        int inactiveInterval = request.getSession().getMaxInactiveInterval();
        renderer.execute(out, templatePath, defaultTemplate, dashboardsMessagesBaseFilename, paramMap, this.userSession.getName(), inactiveInterval, isRequire, loadTheme);
    }

    public String getPluginName() {
        return PLUGIN_ID;
    }

    public String getContext(@QueryParam(value="path") @DefaultValue(value="") String path, @QueryParam(value="action") @DefaultValue(value="") String action, @DefaultValue(value="") @QueryParam(value="view") String view, @Context HttpServletRequest servletRequest) {
        int inactiveInterval = servletRequest.getSession().getMaxInactiveInterval();
        return ContextEngine.getInstance().getContext(path, Parameter.asHashMap(servletRequest), inactiveInterval);
    }

    public String getHeaders(@QueryParam(value="dashboardContent") String dashboardContent, @QueryParam(value="dashboardType") String dashboardType, @QueryParam(value="absolute") @DefaultValue(value="false") String absolute, @QueryParam(value="root") String root, @QueryParam(value="scheme") String scheme, @QueryParam(value="debug") @DefaultValue(value="false") String debug, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws Exception {
        try {
            CdfHtmlRenderer.getHeaders(dashboardContent, dashboardType, Boolean.parseBoolean(absolute), root, scheme, Boolean.parseBoolean(debug), (OutputStream)servletResponse.getOutputStream());
        }
        catch (IOException ex) {
            logger.error((Object)("getHeaders: " + ex.getMessage()), (Throwable)ex);
            throw ex;
        }
        return null;
    }

    public boolean isCdfResource() {
        return this.cdfResource;
    }

    public void setCdfResource(boolean cdfResource) {
        this.cdfResource = cdfResource;
    }
}

