/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import org.pentaho.platform.api.engine.ICacheManager;
import org.pentaho.platform.api.engine.ILogoutListener;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSystem;

public class CdfSessionCache
implements ILogoutListener {
    private static final String CDF_CACHE = "CDF_CACHE_";
    private static ICacheManager cacheManager = PentahoSystem.getCacheManager(null);
    private static CdfSessionCache cdfSessionCache = new CdfSessionCache();

    private CdfSessionCache() {
        PentahoSystem.addLogoutListener((ILogoutListener)this);
    }

    public static CdfSessionCache getInstance() {
        return cdfSessionCache;
    }

    public boolean initCacheRegion(IPentahoSession session) throws IllegalStateException {
        return this.initCacheRegion(this.getCdfRegion(session));
    }

    public boolean initCacheRegion(String region) throws IllegalStateException {
        if (!cacheManager.cacheEnabled(region) && !cacheManager.addCacheRegion(region)) {
            throw new IllegalStateException("CDF cache cannot be initialized.");
        }
        return true;
    }

    public void putInCdfSessionCache(IPentahoSession session, Object key, Object value) throws IllegalStateException {
        assert (session != null);
        String region = this.getCdfRegion(session);
        this.initCacheRegion(region);
        cacheManager.putInRegionCache(region, key, value);
    }

    public Object getFromCdfSessionCache(IPentahoSession session, Object key) throws IllegalStateException {
        assert (session != null);
        String region = this.getCdfRegion(session);
        this.initCacheRegion(region);
        return cacheManager.getFromRegionCache(region, key);
    }

    public void clearCdfSessionCache(IPentahoSession session) throws IllegalStateException {
        assert (session != null);
        String region = this.getCdfRegion(session);
        this.initCacheRegion(region);
        cacheManager.clearRegionCache(region);
    }

    protected String getCdfRegion(IPentahoSession session) {
        String rtn = (String)session.getAttribute(CDF_CACHE);
        if (rtn == null) {
            rtn = CDF_CACHE + '_' + session.getId();
            session.setAttribute(CDF_CACHE, (Object)rtn);
        }
        return rtn;
    }

    public void onLogout(IPentahoSession session) {
        cacheManager.removeRegionCache(this.getCdfRegion(session));
    }
}

