/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf;

import java.util.Hashtable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.Node;
import org.pentaho.cdf.environment.CdfEngine;
import pt.webdetails.cpf.plugins.Plugin;
import pt.webdetails.cpf.plugins.PluginsAnalyzer;
import pt.webdetails.cpf.repository.api.IContentAccessFactory;
import pt.webdetails.cpf.repository.api.IReadAccess;
import pt.webdetails.cpf.utils.XmlDom4JUtils;

public class PluginCatalogEngine {
    private static final Log logger = LogFactory.getLog(PluginCatalogEngine.class);
    public String path;
    private static PluginCatalogEngine engine;
    private Hashtable<String, String> pluginPool;
    private static final String PLUGIN_XML = "plugin.xml";

    public PluginCatalogEngine() {
        this.catalogPlugins();
    }

    public static PluginCatalogEngine getInstance() {
        if (engine == null) {
            engine = new PluginCatalogEngine();
        }
        return engine;
    }

    public void refresh() {
        this.catalogPlugins();
    }

    public Hashtable<String, String> getPlugins() {
        return this.pluginPool;
    }

    private void catalogPlugins() {
        this.pluginPool = new Hashtable();
        this.pluginPool.put("xaction", "ViewAction?solution={solution}&path={path}&action={name}");
        List installedPlugins = new PluginsAnalyzer().getInstalledPlugins();
        if (installedPlugins == null) {
            logger.error((Object)"PluginCatalogEngine found zero installed plugins");
            return;
        }
        IContentAccessFactory accessFactory = CdfEngine.getEnvironment().getContentAccessFactory();
        for (Plugin plugin : installedPlugins) {
            try {
                IReadAccess pluginSystemAccess = accessFactory.getOtherPluginSystemReader(plugin.getId(), null);
                Document xml = XmlDom4JUtils.getDocumentFromFile((IReadAccess)pluginSystemAccess, (String)PLUGIN_XML);
                List list = xml.selectNodes("//content-type[@type]");
                String readType = null;
                for (Node node : list) {
                    readType = XmlDom4JUtils.getNodeText((String)"@type", (Node)node);
                }
                if (readType == null) continue;
                String rawUrl = xml.selectSingleNode("//operation/id[text()='RUN']/../command").getText();
                this.pluginPool.put(readType, rawUrl);
            }
            catch (Exception e) {
                logger.error((Object)("error while resolving plugin.xml for pluginId " + plugin), (Throwable)e);
            }
        }
    }
}

