/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.context;

import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.pentaho.cdf.context.ContextEngine;
import org.pentaho.cdf.util.Parameter;
import org.pentaho.cdf.utils.CorsUtil;
import org.pentaho.cdf.utils.JsonUtil;
import pt.webdetails.cpf.utils.CharsetHelper;
import pt.webdetails.cpf.utils.PluginIOUtils;

@Path(value="/pentaho-cdf/api/context")
public class ContextApi {
    private static final Log logger = LogFactory.getLog(ContextApi.class);

    @GET
    @Path(value="/get")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/json"})
    public Response get(@QueryParam(value="path") String path, @QueryParam(value="user") String user, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) {
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        this.setCorsHeaders(servletRequest, servletResponse);
        return this.buildContext(path, user, servletRequest);
    }

    @GET
    @Path(value="/getConfig")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/json"})
    public void getConfig(@QueryParam(value="path") String path, @QueryParam(value="view") String view, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws IOException {
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        this.setCorsHeaders(servletRequest, servletResponse);
        this.writeConfig(path, servletRequest, servletResponse);
    }

    protected void setCorsHeaders(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        CorsUtil.getInstance().setCorsHeaders(servletRequest, servletResponse);
    }

    protected Response buildContext(String path, String user, HttpServletRequest servletRequest) {
        try {
            return Response.ok((Object)ContextEngine.getInstance().buildContext(path, user, Parameter.asHashMap(servletRequest), servletRequest.getSession().getMaxInactiveInterval()).toString(2)).build();
        }
        catch (JSONException e) {
            logger.error((Object)"Error getting context", (Throwable)e);
            return Response.serverError().build();
        }
    }

    protected void writeConfig(String path, HttpServletRequest servletRequest, HttpServletResponse servletResponse) throws IOException {
        try {
            PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)ContextEngine.getInstance().getConfig(path, Parameter.asHashMap(servletRequest), servletRequest.getSession().getMaxInactiveInterval()));
        }
        catch (JSONException e) {
            logger.error((Object)"Error getting config", (Throwable)e);
            PluginIOUtils.writeOutAndFlush((OutputStream)servletResponse.getOutputStream(), (String)JsonUtil.makeJsonErrorResponse((String)("Error getting config: " + e.getMessage()), (boolean)false).toString());
        }
    }
}

