/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.context.autoinclude;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;

class DashboardMatchRule {
    private static Pattern REPLACE_TOKEN = Pattern.compile("\\$([0-9]+)");
    private static final Log log = LogFactory.getLog(DashboardMatchRule.class);
    private Pattern regex;
    private Mode mode;

    public DashboardMatchRule(Matcher cdaMatcher, Node ruleNode) {
        this.mode = DashboardMatchRule.parseMode(ruleNode.getName());
        this.regex = this.replaceTokens(cdaMatcher, ruleNode.getText());
    }

    public boolean canInclude(String dashboardPath, boolean result) {
        switch (this.mode) {
            case EXCLUDE: {
                if (!result) {
                    return false;
                }
                return !this.regex.matcher(dashboardPath).matches();
            }
            case INCLUDE: {
                if (result) {
                    return true;
                }
                return this.regex.matcher(dashboardPath).matches();
            }
        }
        throw new IllegalStateException("Invalid rule!");
    }

    private static Mode parseMode(String nodeName) {
        if (nodeName.equals("include")) {
            return Mode.INCLUDE;
        }
        if (nodeName.equals("exclude")) {
            return Mode.EXCLUDE;
        }
        throw new IllegalArgumentException("Inclusion rule mode " + nodeName + " not supported.");
    }

    private Pattern replaceTokens(Matcher cdaMatcher, String regex) {
        Matcher token = REPLACE_TOKEN.matcher(regex);
        StringBuffer sb = new StringBuffer();
        while (token.find()) {
            int group = Integer.parseInt(token.group(1));
            if (group < cdaMatcher.groupCount()) {
                token.appendReplacement(sb, Matcher.quoteReplacement(Pattern.quote(cdaMatcher.group(group))));
                continue;
            }
            log.error((Object)String.format("Error processing rule '%s', group %d does not exist.", regex, group));
        }
        token.appendTail(sb);
        return Pattern.compile(sb.toString());
    }

    public String toString() {
        return (Object)((Object)this.mode) + "(" + this.regex + ")";
    }

    public static enum Mode {
        INCLUDE,
        EXCLUDE;

    }
}

