/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.environment;

import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.cdf.environment.ICdfEnvironment;
import org.pentaho.cdf.environment.broker.ICdfInterPluginBroker;
import org.pentaho.cdf.environment.broker.PentahoCdfInterPluginBroker;
import org.pentaho.cdf.environment.configurations.IHibernateConfigurations;
import org.pentaho.cdf.environment.configurations.PentahoHibernanteConfigurations;
import org.pentaho.cdf.environment.packager.ICdfHeadersProvider;
import org.pentaho.cdf.environment.paths.CdfApiPathProvider;
import org.pentaho.cdf.environment.paths.ICdfApiPathProvider;
import org.pentaho.cdf.environment.templater.ITemplater;
import org.pentaho.cdf.packager.CdfHeadersProvider;
import org.pentaho.cdf.templater.PentahoUITemplater;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.util.messages.LocaleHelper;
import pt.webdetails.cpf.PentahoPluginEnvironment;
import pt.webdetails.cpf.PentahoUrlProvider;
import pt.webdetails.cpf.PluginEnvironment;
import pt.webdetails.cpf.Util;
import pt.webdetails.cpf.bean.IBeanFactory;
import pt.webdetails.cpf.context.api.IUrlProvider;
import pt.webdetails.cpf.exceptions.InitializationException;
import pt.webdetails.cpf.resources.IResourceLoader;

public class PentahoCdfEnvironment
extends PentahoPluginEnvironment
implements ICdfEnvironment {
    protected static Log logger = LogFactory.getLog(PentahoCdfEnvironment.class);
    private static final String PLUGIN_REPOSITORY_DIR = "/public/cdf";
    private static final String SYSTEM_DIR = "system";
    private static final String PLUGIN = "plugin";
    private IBeanFactory factory;
    private IResourceLoader resourceLoader;
    private IHibernateConfigurations pentahoHibernateConfigurations;
    private ICdfApiPathProvider cdfApipathProvider;
    private ICdfHeadersProvider cdfHeadersProvider;

    public void init(IBeanFactory factory) throws InitializationException {
        this.factory = factory;
        this.pentahoHibernateConfigurations = new PentahoHibernanteConfigurations();
        this.cdfApipathProvider = new CdfApiPathProvider(this.getPluginEnv().getUrlProvider());
        this.cdfHeadersProvider = new CdfHeadersProvider();
        if (factory.containsBean(IResourceLoader.class.getSimpleName())) {
            this.resourceLoader = (IResourceLoader)factory.getBean(IResourceLoader.class.getSimpleName());
        }
        PentahoPluginEnvironment.init((PluginEnvironment)this);
    }

    public void refresh() {
        try {
            this.init(this.factory);
        }
        catch (InitializationException e) {
            logger.error((Object)"refresh()", (Throwable)e);
        }
    }

    public String getApplicationBaseUrl() {
        return PentahoSystem.getApplicationContext().getBaseUrl();
    }

    public Locale getLocale() {
        return LocaleHelper.getLocale();
    }

    public IResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public String getPluginId() {
        return super.getPluginId();
    }

    public String getApplicationBaseContentUrl() {
        return Util.joinPath((String[])new String[]{this.getApplicationBaseUrl(), PLUGIN, this.getPluginId()}) + "/";
    }

    public String getRepositoryBaseContentUrl() {
        return Util.joinPath((String[])new String[]{this.getApplicationBaseUrl(), PLUGIN, this.getPluginId()}) + "/res/";
    }

    protected String getPluginRepositoryDir() {
        return PLUGIN_REPOSITORY_DIR;
    }

    public PentahoPluginEnvironment getPluginEnv() {
        return PentahoPluginEnvironment.getInstance();
    }

    public ICdfApiPathProvider getPathProvider() {
        return this.cdfApipathProvider;
    }

    public IHibernateConfigurations getHibernateConfigurations() {
        return this.pentahoHibernateConfigurations;
    }

    public String getSystemEncoding() {
        return LocaleHelper.getSystemEncoding();
    }

    public ICdfHeadersProvider getCdfHeadersProvider() {
        return this.cdfHeadersProvider;
    }

    public ITemplater getTemplater() {
        return PentahoUITemplater.getInstance();
    }

    public ICdfInterPluginBroker getCdfInterPluginBroker() {
        return PentahoCdfInterPluginBroker.getInstance();
    }

    public String getCdfPluginRepositoryDir() {
        return PLUGIN_REPOSITORY_DIR;
    }

    public IUrlProvider getUrlProvider() {
        return new PentahoUrlProvider(this.getPluginId()){

            public String getResourcesBasePath() {
                return PentahoCdfEnvironment.this.getPathProvider().getResourcesBasePath();
            }
        };
    }

    public String getSystemDir() {
        return SYSTEM_DIR;
    }
}

