/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.storage;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.security.SecurityHelper;

class ImpersonationHandler {
    private static final Log logger = LogFactory.getLog(ImpersonationHandler.class);

    ImpersonationHandler() {
    }

    static String getUserName(String impersonat) throws CdfStorageApiImpersonationException {
        IPentahoSession session = PentahoSessionHolder.getSession();
        if (session != null) {
            String sessUser = session.getName();
            if (StringUtils.isEmpty((String)impersonat)) {
                return sessUser;
            }
            if (sessUser.equals(impersonat)) {
                return impersonat;
            }
            boolean isAdmin = SecurityHelper.getInstance().isPentahoAdministrator(session);
            if (isAdmin) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)("User " + sessUser + " has been impersonated as " + impersonat));
                }
                return impersonat;
            }
            if (logger.isErrorEnabled()) {
                logger.error((Object)("User " + sessUser + " has been denied to be impersonated as " + impersonat + " - no Admin permission."));
            }
            return sessUser;
        }
        if (logger.isErrorEnabled()) {
            logger.error((Object)("Impersanation as user " + impersonat + " has been denied. No session"));
        }
        throw new CdfStorageApiImpersonationException();
    }

    static class CdfStorageApiImpersonationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CdfStorageApiImpersonationException() {
        }

        public CdfStorageApiImpersonationException(String msg) {
            super(msg);
        }

        public CdfStorageApiImpersonationException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

