/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.cdf.storage;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.json.JSONException;
import org.json.JSONObject;
import org.pentaho.cdf.InvalidCdfOperationException;
import org.pentaho.cdf.PluginHibernateException;
import org.pentaho.cdf.storage.ImpersonationHandler;
import org.pentaho.cdf.storage.StorageEngine;
import org.pentaho.cdf.storage.StorageEngineInterface;
import org.pentaho.cdf.utils.CorsUtil;
import pt.webdetails.cpf.utils.CharsetHelper;

@Path(value="/pentaho-cdf/api/storage")
public class StorageApi {
    private StorageEngineInterface engine = null;
    private static final Response FORBIDDEN = Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)new JSONObject((Map)new HashMap<String, String>(){
        {
            this.put("error", "no session found");
        }
    })).build();

    public StorageApi() {
        this(StorageEngine.getInstance());
    }

    public StorageApi(StorageEngineInterface engine) {
        this.engine = engine;
    }

    @GET
    @Path(value="/store")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/json"})
    public Response store(@QueryParam(value="storageValue") String storageValue, @QueryParam(value="user") String user, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws InvalidCdfOperationException, JSONException, PluginHibernateException {
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        this.setCorsHeaders(servletRequest, servletResponse);
        return this.store(storageValue, user);
    }

    @GET
    @Path(value="/read")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/json"})
    public String read(@QueryParam(value="user") String user, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws InvalidCdfOperationException, JSONException, PluginHibernateException, IOException {
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        this.setCorsHeaders(servletRequest, servletResponse);
        try {
            return this.read(user);
        }
        catch (ImpersonationHandler.CdfStorageApiImpersonationException e) {
            servletResponse.sendError(403, FORBIDDEN.getEntity().toString());
            return null;
        }
    }

    @GET
    @Path(value="/delete")
    @Consumes(value={"application/xml", "application/json"})
    @Produces(value={"application/json"})
    public Response delete(@QueryParam(value="user") String user, @Context HttpServletRequest servletRequest, @Context HttpServletResponse servletResponse) throws InvalidCdfOperationException, JSONException, PluginHibernateException {
        servletResponse.setContentType("application/json");
        servletResponse.setCharacterEncoding(CharsetHelper.getEncoding());
        this.setCorsHeaders(servletRequest, servletResponse);
        return this.delete(user);
    }

    protected void setCorsHeaders(HttpServletRequest servletRequest, HttpServletResponse servletResponse) {
        CorsUtil.getInstance().setCorsHeaders(servletRequest, servletResponse);
    }

    protected Response store(String storageValue, String user) throws PluginHibernateException, JSONException, InvalidCdfOperationException {
        try {
            return Response.ok((Object)this.engine.store(storageValue, this.impersonate(user)).toString(2)).build();
        }
        catch (ImpersonationHandler.CdfStorageApiImpersonationException e) {
            return FORBIDDEN;
        }
    }

    protected String read(String user) throws PluginHibernateException, JSONException, InvalidCdfOperationException, ImpersonationHandler.CdfStorageApiImpersonationException {
        return this.engine.read(this.impersonate(user)).toString(2);
    }

    protected Response delete(String user) throws PluginHibernateException, JSONException, InvalidCdfOperationException {
        try {
            return Response.ok((Object)this.engine.delete(this.impersonate(user)).toString(2)).build();
        }
        catch (ImpersonationHandler.CdfStorageApiImpersonationException e) {
            return FORBIDDEN;
        }
    }

    protected String impersonate(String user) throws ImpersonationHandler.CdfStorageApiImpersonationException {
        return ImpersonationHandler.getUserName(user);
    }
}

