/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.requirejs.impl.types;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.requirejs.IRequireJsPackage;

public class MetaInfPackageJson
implements IRequireJsPackage {
    private final Map<String, Object> packageJsonObject;
    private String name;
    private String version;
    private final Map<String, String> modules;
    private final Map<String, String> packages;
    private final Map<String, String> dependencies;
    private final Map<String, Map<String, ?>> config;
    private final Map<String, Map<String, String>> localMap;
    private final Map<String, Map<String, ?>> shim;

    public MetaInfPackageJson(Map<String, Object> packageJsonObject) {
        this.packageJsonObject = packageJsonObject;
        this.modules = new HashMap<String, String>();
        this.packages = new HashMap<String, String>();
        this.dependencies = new HashMap<String, String>();
        this.config = new HashMap();
        this.localMap = new HashMap<String, Map<String, String>>();
        this.shim = new HashMap();
        this.init();
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getWebRootPath() {
        return this.name + "/" + this.version;
    }

    public boolean preferGlobal() {
        return false;
    }

    private void addModule(String moduleId, String path) {
        this.modules.put(moduleId, path);
    }

    private void addModule(String moduleId, String path, String main) {
        this.modules.put(moduleId, path);
        this.packages.put(moduleId, main);
    }

    public Map<String, String> getModules() {
        return Collections.unmodifiableMap(this.modules);
    }

    public String getModuleMainFile(String moduleId) {
        return this.packages.get(moduleId);
    }

    private void addDependency(String packageName, String version) {
        this.dependencies.put(packageName, version);
    }

    public Map<String, String> getDependencies() {
        return Collections.unmodifiableMap(this.dependencies);
    }

    public boolean hasScript(String name) {
        return false;
    }

    public URL getScriptResource(String name) {
        return null;
    }

    private void addConfig(String moduleId, Map<String, ?> configuration) {
        this.config.put(moduleId, configuration);
    }

    public Map<String, Map<String, ?>> getConfig() {
        return Collections.unmodifiableMap(this.config);
    }

    private void addMap(String where, String originalModuleId, String mappedModuleId) {
        this.localMap.computeIfAbsent(where, m -> new HashMap()).put(originalModuleId, mappedModuleId);
    }

    public Map<String, Map<String, String>> getMap() {
        return Collections.unmodifiableMap(this.localMap);
    }

    private void addShim(String moduleId, Map<String, ?> configuration) {
        this.shim.put(moduleId, configuration);
    }

    public Map<String, Map<String, ?>> getShim() {
        return Collections.unmodifiableMap(this.shim);
    }

    private void init() {
        this.initFromPackageJson(this.packageJsonObject);
    }

    private void initFromPackageJson(Map<String, Object> json) {
        this.name = (String)json.get("name");
        this.version = (String)json.get("version");
        String versionedModuleId = this.name + "_" + this.version;
        String versionedPath = this.name + "/" + this.version;
        this.addModule(this.name, "/");
        if (json.containsKey("paths")) {
            Map paths = (Map)json.get("paths");
            paths.forEach((moduleId, path) -> {
                if (path instanceof String) {
                    this.addModule((String)moduleId, (String)path);
                }
            });
        }
        if (json.containsKey("main")) {
            String file = (String)json.get("main");
            if (file.startsWith("./")) {
                file = file.substring(2);
            } else if (file.startsWith("/")) {
                file = file.substring(1);
            }
            if (file.endsWith(".js")) {
                String filename = file.substring(0, file.length() - 3);
                this.addModule(this.getName(), this.modules.get(this.getName()), filename);
            }
        }
        if (json.containsKey("packages")) {
            List packages = (List)json.get("packages");
            packages.forEach(packageDefinition -> {
                HashMap packageObj;
                if (packageDefinition instanceof String) {
                    String packageName = (String)packageDefinition;
                    this.addModule(this.getName() + "/" + packageName, null, "main");
                } else if (packageDefinition instanceof HashMap && (packageObj = (HashMap)packageDefinition).containsKey("name")) {
                    String packageName = (String)packageObj.get("name");
                    String path = (String)packageObj.get("location");
                    String mainScript = packageObj.getOrDefault("main", "main");
                    if (path != null && path.startsWith(versionedPath)) {
                        path = path.substring(versionedPath.length());
                    }
                    this.addModule(this.getName() + "/" + packageName, path, mainScript);
                }
            });
        }
        if (json.containsKey("dependencies")) {
            Map dependencies = (Map)json.get("dependencies");
            dependencies.forEach((packageName, version) -> {
                if (version instanceof String) {
                    this.addDependency((String)packageName, (String)version);
                }
            });
        }
        if (json.containsKey("config")) {
            Map config = (Map)json.get("config");
            config.forEach((moduleId, configuration) -> {
                if (configuration instanceof Map) {
                    if (moduleId.equals("pentaho/modules")) {
                        HashMap newConfiguration = new HashMap();
                        ((Map)configuration).forEach((maybeVersionedModuleId, moduleInfo) -> {
                            String notVersionedModuleId = maybeVersionedModuleId;
                            if (maybeVersionedModuleId.startsWith(versionedModuleId)) {
                                notVersionedModuleId = this.getName() + maybeVersionedModuleId.substring(versionedModuleId.length());
                            }
                            newConfiguration.put(notVersionedModuleId, moduleInfo);
                        });
                        this.addConfig((String)moduleId, newConfiguration);
                    } else {
                        this.addConfig((String)moduleId, (Map)configuration);
                    }
                }
            });
        }
        if (json.containsKey("map")) {
            Map map = (Map)json.get("map");
            map.forEach((originalModuleId, mappedModuleId) -> {
                if (mappedModuleId instanceof String) {
                    this.addMap(this.name, (String)originalModuleId, (String)mappedModuleId);
                }
            });
        }
        if (json.containsKey("shim")) {
            Map shim = (Map)json.get("shim");
            shim.forEach((moduleId, configuration) -> {
                if (configuration instanceof Map) {
                    this.addShim((String)moduleId, (Map)configuration);
                } else if (configuration instanceof List) {
                    HashMap<String, Object> deps = new HashMap<String, Object>();
                    deps.put("deps", configuration);
                    this.addShim((String)moduleId, (Map<String, ?>)deps);
                }
            });
        }
    }
}

