/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.google.common.collect.ImmutableMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.HiveMetaException;
import org.apache.hadoop.hive.metastore.IMetaStoreSchemaInfo;
import org.apache.hadoop.hive.metastore.tools.HiveSchemaHelper;
import org.apache.hive.common.util.HiveVersionInfo;

public class MetaStoreSchemaInfo
implements IMetaStoreSchemaInfo {
    protected static final String UPGRADE_FILE_PREFIX = "upgrade-";
    private static final String INIT_FILE_PREFIX = "hive-schema-";
    private static final String VERSION_UPGRADE_LIST = "upgrade.order";
    private static final String PRE_UPGRADE_PREFIX = "pre-";
    protected final String dbType;
    private String[] hiveSchemaVersions;
    private final String hiveHome;
    private static final Map<String, String> EQUIVALENT_VERSIONS = ImmutableMap.of((Object)"0.13.1", (Object)"0.13.0", (Object)"1.0.0", (Object)"0.14.0");

    public MetaStoreSchemaInfo(String hiveHome, String dbType) throws HiveMetaException {
        this.hiveHome = hiveHome;
        this.dbType = dbType;
    }

    private void loadAllUpgradeScripts(String dbType) throws HiveMetaException {
        ArrayList<String> upgradeOrderList = new ArrayList<String>();
        String upgradeListFile = this.getMetaStoreScriptDir() + File.separator + VERSION_UPGRADE_LIST + "." + dbType;
        try (BufferedReader bfReader = new BufferedReader(new FileReader(upgradeListFile));){
            String currSchemaVersion;
            while ((currSchemaVersion = bfReader.readLine()) != null) {
                upgradeOrderList.add(currSchemaVersion.trim());
            }
        }
        catch (FileNotFoundException e) {
            throw new HiveMetaException("File " + upgradeListFile + "not found ", e);
        }
        catch (IOException e) {
            throw new HiveMetaException("Error reading " + upgradeListFile, e);
        }
        this.hiveSchemaVersions = upgradeOrderList.toArray(new String[0]);
    }

    @Override
    public List<String> getUpgradeScripts(String fromVersion) throws HiveMetaException {
        int i;
        ArrayList<String> upgradeScriptList = new ArrayList<String>();
        if (this.getHiveSchemaVersion().equals(fromVersion)) {
            return upgradeScriptList;
        }
        this.loadAllUpgradeScripts(this.dbType);
        int firstScript = this.hiveSchemaVersions.length;
        for (i = 0; i < this.hiveSchemaVersions.length; ++i) {
            if (!this.hiveSchemaVersions[i].startsWith(fromVersion)) continue;
            firstScript = i;
        }
        if (firstScript == this.hiveSchemaVersions.length) {
            throw new HiveMetaException("Unknown version specified for upgrade " + fromVersion + " Metastore schema may be too old or newer");
        }
        for (i = firstScript; i < this.hiveSchemaVersions.length; ++i) {
            String scriptFile = this.generateUpgradeFileName(this.hiveSchemaVersions[i]);
            upgradeScriptList.add(scriptFile);
        }
        return upgradeScriptList;
    }

    @Override
    public String generateInitFileName(String toVersion) throws HiveMetaException {
        if (toVersion == null) {
            toVersion = this.getHiveSchemaVersion();
        }
        String initScriptName = INIT_FILE_PREFIX + toVersion + "." + this.dbType + ".sql";
        if (!new File(this.getMetaStoreScriptDir() + File.separatorChar + initScriptName).exists()) {
            throw new HiveMetaException("Unknown version specified for initialization: " + toVersion);
        }
        return initScriptName;
    }

    @Override
    public String getMetaStoreScriptDir() {
        return this.hiveHome + File.separatorChar + "scripts" + File.separatorChar + "metastore" + File.separatorChar + "upgrade" + File.separatorChar + this.dbType;
    }

    private String generateUpgradeFileName(String fileVersion) {
        return UPGRADE_FILE_PREFIX + fileVersion + "." + this.dbType + ".sql";
    }

    @Override
    public String getPreUpgradeScriptName(int index, String upgradeScriptName) {
        return PRE_UPGRADE_PREFIX + index + "-" + upgradeScriptName;
    }

    @Override
    public String getHiveSchemaVersion() {
        String hiveVersion = HiveVersionInfo.getShortVersion();
        return MetaStoreSchemaInfo.getEquivalentVersion(hiveVersion);
    }

    private static String getEquivalentVersion(String hiveVersion) {
        String equivalentVersion = EQUIVALENT_VERSIONS.get(hiveVersion);
        if (equivalentVersion != null) {
            return equivalentVersion;
        }
        return hiveVersion;
    }

    @Override
    public boolean isVersionCompatible(String hiveVersion, String dbVersion) {
        if ((hiveVersion = MetaStoreSchemaInfo.getEquivalentVersion(hiveVersion)).equals(dbVersion = MetaStoreSchemaInfo.getEquivalentVersion(dbVersion))) {
            return true;
        }
        String[] hiveVerParts = hiveVersion.split("\\.");
        String[] dbVerParts = dbVersion.split("\\.");
        if (hiveVerParts.length != 3 || dbVerParts.length != 3) {
            return false;
        }
        for (int i = 0; i < dbVerParts.length; ++i) {
            Integer dbVerPart = Integer.valueOf(dbVerParts[i]);
            Integer hiveVerPart = Integer.valueOf(hiveVerParts[i]);
            if (dbVerPart > hiveVerPart) {
                return true;
            }
            if (dbVerPart >= hiveVerPart) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String getMetaStoreSchemaVersion(HiveSchemaHelper.MetaStoreConnectionInfo connectionInfo) throws HiveMetaException {
        boolean needsQuotedIdentifier = HiveSchemaHelper.getDbCommandParser(connectionInfo.getDbType()).needsQuotedIdentifier();
        String versionQuery = needsQuotedIdentifier ? "select t.\"SCHEMA_VERSION\" from \"VERSION\" t" : "select t.SCHEMA_VERSION from VERSION t";
        try (Connection metastoreDbConnection = HiveSchemaHelper.getConnectionToMetastore(connectionInfo);){
            Statement stmt = metastoreDbConnection.createStatement();
            ResultSet res = stmt.executeQuery(versionQuery);
            if (!res.next()) {
                throw new HiveMetaException("Could not find version info in metastore VERSION table.");
            }
            String currentSchemaVersion = res.getString(1);
            if (res.next()) {
                throw new HiveMetaException("Multiple versions were found in metastore.");
            }
            String string = currentSchemaVersion;
            return string;
        }
        catch (SQLException e) {
            throw new HiveMetaException("Failed to get schema version, Cause:" + e.getMessage());
        }
    }
}

