/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;
import org.pentaho.reporting.libraries.xmlns.common.AttributeMap;

public class ReportAttributeMap<T>
extends AttributeMap<T> {
    private static final Log logger = LogFactory.getLog(ReportAttributeMap.class);
    public static final ReportAttributeMap EMPTY_MAP = new ReportAttributeMap().createUnmodifiableMap();
    private long changeTracker;

    public static <T> ReportAttributeMap<T> emptyMap() {
        return EMPTY_MAP;
    }

    public ReportAttributeMap() {
        this(0L);
    }

    public ReportAttributeMap(long changeTracker) {
        this.changeTracker = changeTracker;
    }

    public ReportAttributeMap(ReportAttributeMap copy) {
        super((AttributeMap)copy);
        this.changeTracker = copy.changeTracker;
    }

    public ReportAttributeMap<T> createUnmodifiableMap() {
        return new Immutable(this);
    }

    public ReportAttributeMap<T> clone() {
        return (ReportAttributeMap)super.clone();
    }

    public long getChangeTracker() {
        return this.changeTracker;
    }

    public <TS extends T> TS getAttributeTyped(String namespace, String attribute, Class<TS> filter) {
        Object val = this.getAttribute(namespace, attribute);
        if (filter.isInstance(val)) {
            return filter.cast(val);
        }
        return null;
    }

    public T setAttribute(String namespace, String attribute, T value) {
        Object oldValue = super.setAttribute(namespace, attribute, value);
        if (oldValue == value) {
            return (T)oldValue;
        }
        if (!ObjectUtilities.equal((Object)oldValue, value)) {
            ++this.changeTracker;
        }
        return (T)oldValue;
    }

    public boolean isReadOnly() {
        return false;
    }

    public void putAll(AttributeMap<T> attributeMap) {
        super.putAll(attributeMap);
        ++this.changeTracker;
    }

    private static class Immutable<T>
    extends ReportAttributeMap<T> {
        public Immutable(ReportAttributeMap<T> map) {
            super(map);
        }

        @Override
        public final boolean isReadOnly() {
            return true;
        }

        @Override
        public final T setAttribute(String namespace, String attribute, T value) {
            throw this.exception();
        }

        @Override
        public final void putAll(AttributeMap<T> attributeMap) {
            throw this.exception();
        }

        private UnsupportedOperationException exception() {
            return new UnsupportedOperationException("This collection is marked as read-only");
        }

        @Override
        public ReportAttributeMap<T> clone() {
            return this;
        }
    }
}

