/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.elementfactory;

import java.awt.Color;
import java.awt.geom.Rectangle2D;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.elementfactory.ElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextElementFactory;
import org.pentaho.reporting.engine.classic.core.filter.types.ResourceLabelType;
import org.pentaho.reporting.engine.classic.core.style.FontDefinition;

public class ResourceLabelElementFactory
extends TextElementFactory {
    private String resourceBase;
    private String nullString;
    private String resourceKey;

    public String getResourceBase() {
        return this.resourceBase;
    }

    public void setResourceBase(String resourceBase) {
        this.resourceBase = resourceBase;
    }

    public String getNullString() {
        return this.nullString;
    }

    public void setNullString(String nullString) {
        this.nullString = nullString;
    }

    public String getResourceKey() {
        return this.resourceKey;
    }

    public void setResourceKey(String resourceKey) {
        this.resourceKey = resourceKey;
    }

    @Override
    public Element createElement() {
        if (this.getResourceKey() == null) {
            throw new IllegalStateException("ResourceKey is not set.");
        }
        Element element = new Element();
        this.applyElementName(element);
        this.applyStyle(element.getStyle());
        element.setElementType(new ResourceLabelType());
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "resource-identifier", this.getResourceBase());
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", this.getResourceKey());
        element.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "null-value", this.getNullString());
        return element;
    }

    public static Element createResourceLabel(String name, Rectangle2D bounds, Color paint, ElementAlignment alignment, ElementAlignment valign, FontDefinition font, String nullValue, String resourceBase, String resourceKey) {
        ResourceLabelElementFactory factory = new ResourceLabelElementFactory();
        factory.setX(new Float(bounds.getX()));
        factory.setY(new Float(bounds.getY()));
        factory.setMinimumWidth(new Float(bounds.getWidth()));
        factory.setMinimumHeight(new Float(bounds.getHeight()));
        factory.setName(name);
        factory.setColor(paint);
        factory.setHorizontalAlignment(alignment);
        factory.setVerticalAlignment(valign);
        if (font != null) {
            factory.setFontName(font.getFontName());
            factory.setFontSize(new Integer(font.getFontSize()));
            factory.setBold(ElementFactory.getBooleanValue(font.isBold()));
            factory.setItalic(ElementFactory.getBooleanValue(font.isItalic()));
            factory.setEncoding(font.getFontEncoding(null));
            factory.setUnderline(ElementFactory.getBooleanValue(font.isUnderline()));
            factory.setStrikethrough(ElementFactory.getBooleanValue(font.isStrikeThrough()));
            factory.setEmbedFont(ElementFactory.getBooleanValue(font.isEmbeddedFont()));
        }
        factory.setNullString(nullValue);
        factory.setResourceBase(resourceBase);
        factory.setResourceKey(resourceKey);
        return factory.createElement();
    }
}

