/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.event;

import java.util.EventObject;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.states.ReportState;

public class ReportEvent
extends EventObject {
    public static final int REPORT_INITIALIZED = 1;
    public static final int PAGE_STARTED = 2;
    public static final int REPORT_STARTED = 4;
    public static final int GROUP_STARTED = 8;
    public static final int ITEMS_STARTED = 16;
    public static final int ITEMS_ADVANCED = 32;
    public static final int ITEMS_FINISHED = 64;
    public static final int GROUP_FINISHED = 128;
    public static final int REPORT_FINISHED = 256;
    public static final int REPORT_DONE = 512;
    public static final int PAGE_FINISHED = 1024;
    public static final int SUMMARY_ROW = 2048;
    public static final int SUMMARY_ROW_START = 6144;
    public static final int SUMMARY_ROW_END = 10240;
    public static final int GROUP_BODY_FINISHED = 32768;
    private static final int RESERVED_BLOCK_1 = 49152;
    public static final int CROSSTABBING = 65536;
    public static final int CROSSTABBING_TABLE = 0x110000;
    public static final int CROSSTABBING_OTHER = 0x210000;
    public static final int CROSSTABBING_ROW = 0x410000;
    public static final int CROSSTABBING_COL = 0x810000;
    public static final int DEEP_TRAVERSING_EVENT = 0x4000000;
    public static final int NO_PARENT_PASSING_EVENT = 0x8000000;
    public static final int ARTIFICIAL_EVENT_CODE = Integer.MIN_VALUE;
    private int type;
    private ReportState originatingState;

    public ReportEvent(ReportState state, int type) {
        super(state);
        if (state == null) {
            throw new NullPointerException("ReportEvent(ReportState) : null not permitted.");
        }
        if (type <= 0) {
            throw new IllegalArgumentException("This is not a valid EventType: " + type);
        }
        this.type = type;
        this.originatingState = state;
    }

    public ReportEvent(ReportState state, ReportState originatingState, int type) {
        this(state, type);
        if (originatingState == null) {
            throw new NullPointerException("Originating state can never be null.");
        }
        this.originatingState = originatingState;
    }

    public int getType() {
        return this.type;
    }

    public ReportState getState() {
        return (ReportState)this.getSource();
    }

    public ReportState getOriginatingState() {
        return this.originatingState;
    }

    public ReportDefinition getReport() {
        return this.getState().getReport();
    }

    public DataRow getDataRow() {
        return this.getState().getDataRow();
    }

    public int getLevel() {
        return this.getState().getLevel();
    }

    public boolean isDeepTraversing() {
        return (this.type & 0x4000000) == 0x4000000;
    }

    public static String translateStateCode(int code) {
        StringBuffer b = new StringBuffer();
        if ((code & 1) == 1) {
            b.append("Report-Init");
        } else if ((code & 2) == 2) {
            b.append("Page-Start");
            int i = code & 0xFFFFFFFD;
            if (i != 0) {
                b.append("[");
                b.append(ReportEvent.translateStateCode(i));
                b.append("]");
            }
        }
        if ((code & 4) == 4) {
            b.append("Report-Start");
        }
        if ((code & 8) == 8) {
            b.append("Group-Start");
        }
        if ((code & 0x10) == 16) {
            b.append("Items-Start");
        }
        if ((code & 0x20) == 32) {
            b.append("Items-Advanced");
        }
        if ((code & 0x40) == 64) {
            b.append("Items-Finished");
        }
        if ((code & 0x8000) == 32768) {
            b.append("Group-Body-Finished");
        }
        if ((code & 0x80) == 128) {
            b.append("Group-Finished");
        }
        if ((code & 0x100) == 256) {
            b.append("Report-Finished");
        }
        if ((code & 0x200) == 512) {
            b.append("Report-Done");
        }
        if ((code & 0x400) == 1024) {
            b.append("Page-Finished");
        }
        if ((code & 0x800) == 2048) {
            b.append("Summary Row");
            if ((code & 0x1800) == 6144) {
                b.append(" [Start]");
            }
            if ((code & 0x2800) == 10240) {
                b.append(" [End]");
            }
        }
        if ((code & 0x10000) == 65536) {
            b.append(" Crosstab");
            if ((code & 0x110000) == 0x110000) {
                b.append(":Table");
            }
            if ((code & 0x210000) == 0x210000) {
                b.append(":Other");
            }
            if ((code & 0x410000) == 0x410000) {
                b.append(":Row");
            }
            if ((code & 0x810000) == 0x810000) {
                b.append(":Col");
            }
        }
        if ((code & 0x8C000000) != 0) {
            b.append(" (");
            if ((code & 0x4000000) == 0x4000000) {
                b.append(" DeepTraverse");
            }
            if ((code & 0x8000000) == 0x8000000) {
                b.append(" NoParent");
            }
            if ((code & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                b.append(" Artificial");
            }
            b.append(" )");
        }
        return b.toString();
    }
}

