/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.Band;
import org.pentaho.reporting.engine.classic.core.CrosstabCell;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroup;
import org.pentaho.reporting.engine.classic.core.CrosstabOtherGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.PageFooter;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.SubGroupBody;
import org.pentaho.reporting.engine.classic.core.SubReport;
import org.pentaho.reporting.engine.classic.core.Watermark;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.LayoutProcessorFunction;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.ElementMetaData;
import org.pentaho.reporting.engine.classic.core.states.ReportState;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public abstract class AbstractElementFormatFunction
extends AbstractFunction
implements PageEventListener,
LayoutProcessorFunction {
    private PerformanceCollector performanceCollector;
    private final Log performanceLogger = LogFactory.getLog(this.getClass());
    private String element;
    private transient String attrName = this.computeUniqueIdentifier();

    protected AbstractElementFormatFunction() {
    }

    public void setElement(String name) {
        this.element = name;
    }

    public String getElement() {
        return this.element;
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        this.performanceCollector = new PerformanceCollector();
        if (!this.isExecutable()) {
            return;
        }
        if (!event.getState().isSubReportEvent()) {
            this.evaluateElement(event.getReport());
        }
        this.processRootBand(event.getReport().getPageHeader());
        this.processRootBand(event.getReport().getWatermark());
    }

    @Override
    public void reportStarted(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        if (!this.isExecutable()) {
            return;
        }
        ReportHeader b = event.getReport().getReportHeader();
        this.processRootBand(b);
        this.processFooterBands(event.getState());
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        if (!this.isExecutable()) {
            return;
        }
        Group group = FunctionUtilities.getCurrentGroup(event);
        this.evaluateElement(group);
        this.processGroupHeaders(group);
        this.evaluateElement(group.getBody());
        this.processFooterBands(event.getState());
    }

    @Override
    public void itemsStarted(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        if (!this.isExecutable()) {
            return;
        }
        if (event.getState().isCrosstabActive()) {
            CrosstabCellBody crosstabCellBody = event.getReport().getCrosstabCellBody();
            this.processRootBand(crosstabCellBody.getHeader());
            this.processRootBand(crosstabCellBody.findElement(null, null));
        } else {
            ReportDefinition reportDefinition = event.getReport();
            this.processRootBand(reportDefinition.getDetailsHeader());
            this.processRootBand(reportDefinition.getNoDataBand());
        }
        this.processFooterBands(event.getState());
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        if (!this.isExecutable()) {
            return;
        }
        if (event.getState().isCrosstabActive()) {
            CrosstabCellBody crosstabCellBody = event.getReport().getCrosstabCellBody();
            this.processRootBand(crosstabCellBody.findElement(null, null));
        } else {
            ItemBand itemBand = event.getReport().getItemBand();
            this.processRootBand(itemBand);
        }
        this.processFooterBands(event.getState());
    }

    @Override
    public void itemsFinished(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        if (!this.isExecutable()) {
            return;
        }
        if (event.getState().isCrosstabActive()) {
            CrosstabCellBody crosstabCellBody = event.getReport().getCrosstabCellBody();
            this.processRootBand(crosstabCellBody.findElement(null, null));
        } else {
            this.processRootBand(event.getReport().getDetailsFooter());
        }
        this.processFooterBands(event.getState());
    }

    @Override
    public void groupFinished(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        if (!this.isExecutable()) {
            return;
        }
        Group group = FunctionUtilities.getCurrentGroup(event);
        if (group instanceof CrosstabColumnGroup) {
            CrosstabCellBody crosstabCellBody = event.getReport().getCrosstabCellBody();
            int elementCount = crosstabCellBody.getElementCount();
            for (int i = 1; i < elementCount; ++i) {
                CrosstabCell cell = (CrosstabCell)crosstabCellBody.getElement(i);
                if (cell.getRowField() != null) continue;
                this.processRootBand(cell);
            }
        } else if (group instanceof CrosstabRowGroup) {
            CrosstabRowGroup rowGroup = (CrosstabRowGroup)group;
            CrosstabCellBody crosstabCellBody = event.getReport().getCrosstabCellBody();
            int elementCount = crosstabCellBody.getElementCount();
            for (int i = 1; i < elementCount; ++i) {
                CrosstabCell cell = (CrosstabCell)crosstabCellBody.getElement(i);
                if (!ObjectUtilities.equal((Object)cell.getRowField(), (Object)rowGroup.getField())) continue;
                this.processRootBand(cell);
            }
        } else {
            this.processAllGroupFooterBands(group);
        }
        this.processFooterBands(event.getState());
    }

    @Override
    public void reportFinished(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        if (!this.isExecutable()) {
            return;
        }
        ReportFooter b = event.getReport().getReportFooter();
        this.processRootBand(b);
        this.processFooterBands(event.getState());
    }

    @Override
    public void reportDone(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        OutputProcessorMetaData outputProcessorMetaData = this.getRuntime().getProcessingContext().getOutputProcessorMetaData();
        if (!outputProcessorMetaData.isFeatureSupported(OutputProcessorFeature.DESIGNTIME)) {
            this.reportCachePerformance();
        }
    }

    protected void reportCachePerformance() {
        if (this.performanceLogger.isInfoEnabled()) {
            this.performanceLogger.info((Object)String.format("Performance: %s => total=%d, evaluated=%d (%f%%), avoided=%d (%f%%)", this.getClass(), this.performanceCollector.totalEvaluations, this.performanceCollector.evaluations, Float.valueOf(100.0f * (float)this.performanceCollector.evaluations / Math.max(1.0f, (float)this.performanceCollector.totalEvaluations)), this.performanceCollector.skippedEvaluations, Float.valueOf(100.0f * (float)this.performanceCollector.skippedEvaluations / Math.max(1.0f, (float)this.performanceCollector.totalEvaluations))));
        }
    }

    protected void processGroupHeaders(Group group) {
        int elementCount = group.getElementCount();
        for (int i = 0; i < elementCount; ++i) {
            Element e = group.getElement(i);
            ElementMetaData.TypeClassification reportElementType = e.getMetaData().getReportElementType();
            if (reportElementType != ElementMetaData.TypeClassification.RELATIONAL_HEADER && reportElementType != ElementMetaData.TypeClassification.HEADER) continue;
            Band b = (Band)e;
            this.processRootBand(b);
        }
    }

    private void processAllGroupFooterBands(Group group) {
        int elementCount = group.getElementCount();
        for (int i = 0; i < elementCount; ++i) {
            Element e = group.getElement(i);
            ElementMetaData.TypeClassification reportElementType = e.getMetaData().getReportElementType();
            if (reportElementType != ElementMetaData.TypeClassification.RELATIONAL_FOOTER && reportElementType != ElementMetaData.TypeClassification.FOOTER) continue;
            Band b = (Band)e;
            this.processRootBand(b);
        }
    }

    @Override
    public void pageFinished(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        if (!this.isExecutable()) {
            return;
        }
        PageFooter b = event.getReport().getPageFooter();
        this.processRootBand(b);
    }

    @Override
    public void pageStarted(ReportEvent event) {
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        if (!this.isExecutable()) {
            return;
        }
        if (this.performanceCollector == null) {
            this.performanceCollector = new PerformanceCollector();
        }
        Watermark w = event.getReport().getWatermark();
        this.processRootBand(w);
        this.processHeaderBands(event.getState());
        this.processFooterBands(event.getState());
    }

    protected void processFooterBands(ReportState state) {
        while (state != null) {
            ReportDefinition reportDefinition = state.getReport();
            this.processRootBand(reportDefinition.getPageFooter());
            if (state.isInItemGroup()) {
                this.processRootBand(reportDefinition.getDetailsFooter());
            }
            Group g = reportDefinition.getRootGroup();
            int groupCounter = 0;
            while (g != null && groupCounter <= state.getCurrentGroupIndex()) {
                GroupBody sgb;
                this.processAllGroupFooterBands(g);
                GroupBody body = g.getBody();
                if (body instanceof SubGroupBody) {
                    ++groupCounter;
                    sgb = (SubGroupBody)body;
                    g = ((SubGroupBody)sgb).getGroup();
                    continue;
                }
                if (!(body instanceof CrosstabOtherGroupBody)) break;
                ++groupCounter;
                sgb = (CrosstabOtherGroupBody)body;
                g = ((CrosstabOtherGroupBody)sgb).getGroup();
            }
            state = state.getParentSubReportState();
        }
    }

    protected void processHeaderBands(ReportState state) {
        while (state != null) {
            ReportDefinition reportDefinition = state.getReport();
            this.processRootBand(reportDefinition.getPageHeader());
            if (state.isInItemGroup()) {
                this.processRootBand(reportDefinition.getDetailsHeader());
            }
            Group g = reportDefinition.getRootGroup();
            int groupCounter = 0;
            while (g != null && groupCounter <= state.getCurrentGroupIndex()) {
                GroupBody sgb;
                this.processGroupHeaders(g);
                GroupBody body = g.getBody();
                if (body instanceof SubGroupBody) {
                    ++groupCounter;
                    sgb = (SubGroupBody)body;
                    g = ((SubGroupBody)sgb).getGroup();
                    continue;
                }
                if (!(body instanceof CrosstabOtherGroupBody)) break;
                ++groupCounter;
                sgb = (CrosstabOtherGroupBody)body;
                g = ((CrosstabOtherGroupBody)sgb).getGroup();
            }
            state = state.getParentSubReportState();
        }
    }

    @Override
    public Object getValue() {
        return null;
    }

    protected boolean isExecutable() {
        return true;
    }

    protected final void processRootBand(Section b) {
        if (b == null) {
            return;
        }
        NeedEvalResult needToRun = (NeedEvalResult)b.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", this.attrName);
        if (needToRun != null && !needToRun.isNeedToRun() && b.getChangeTracker() == needToRun.getChangeTracker()) {
            this.recordCacheHit(b);
            return;
        }
        this.recordCacheMiss(b);
        boolean needToRunVal = this.processBand(b);
        b.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/internal", this.attrName, new NeedEvalResult(needToRunVal, b.getChangeTracker()), false);
    }

    protected void recordCacheHit(ReportElement e) {
        ++this.performanceCollector.totalEvaluations;
        ++this.performanceCollector.skippedEvaluations;
    }

    protected void recordCacheMiss(ReportElement e) {
        ++this.performanceCollector.totalEvaluations;
        ++this.performanceCollector.evaluations;
    }

    protected abstract boolean evaluateElement(ReportElement var1);

    protected final boolean processBand(Section b) {
        boolean hasAttrExpressions = this.evaluateElement(b);
        int length = b.getElementCount();
        for (int i = 0; i < length; ++i) {
            Element element = b.getElement(i);
            ElementMetaData.TypeClassification reportElementType = element.getMetaData().getReportElementType();
            if (reportElementType == ElementMetaData.TypeClassification.DATA || reportElementType == ElementMetaData.TypeClassification.CONTROL || reportElementType == ElementMetaData.TypeClassification.SUBREPORT || !(element instanceof Section)) {
                if (!this.evaluateElement(element)) continue;
                hasAttrExpressions = true;
                continue;
            }
            Section section = (Section)element;
            if (!this.processBand(section)) continue;
            hasAttrExpressions = true;
        }
        if (b instanceof RootLevelBand) {
            RootLevelBand rlb = (RootLevelBand)((Object)b);
            SubReport[] reports = rlb.getSubReports();
            for (int i = 0; i < reports.length; ++i) {
                SubReport subReport = reports[i];
                if (!this.evaluateElement(subReport)) continue;
                hasAttrExpressions = true;
            }
        }
        return hasAttrExpressions;
    }

    @Override
    public final int getDependencyLevel() {
        return -2;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.attrName = this.computeUniqueIdentifier();
    }

    @Override
    public AbstractElementFormatFunction getInstance() {
        AbstractElementFormatFunction expression = (AbstractElementFormatFunction)super.getInstance();
        expression.attrName = this.computeUniqueIdentifier();
        return expression;
    }

    private String computeUniqueIdentifier() {
        return "need-eval-result:" + this.getClass().getName() + '@' + System.identityHashCode(this);
    }

    private static class PerformanceCollector
    implements Serializable {
        public int totalEvaluations;
        public int evaluations;
        public int skippedEvaluations;

        private PerformanceCollector() {
        }
    }

    private static class NeedEvalResult {
        private boolean needToRun;
        private long changeTracker;

        private NeedEvalResult(boolean needToRun, long changeTracker) {
            this.needToRun = needToRun;
            this.changeTracker = changeTracker;
        }

        public boolean isNeedToRun() {
            return this.needToRun;
        }

        public long getChangeTracker() {
            return this.changeTracker;
        }

        public String toString() {
            return "NeedEvalResult{needToRun=" + this.needToRun + ", changeTracker=" + this.changeTracker + '}';
        }
    }
}

