/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function;

import java.awt.Color;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.CrosstabCellBody;
import org.pentaho.reporting.engine.classic.core.CrosstabColumnGroupBody;
import org.pentaho.reporting.engine.classic.core.CrosstabRowGroup;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.event.PageEventListener;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractFunction;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.LayoutProcessorFunction;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.libraries.base.util.StringUtils;

public class RowBandingFunction
extends AbstractFunction
implements PageEventListener,
LayoutProcessorFunction {
    private static final Log logger = LogFactory.getLog(RowBandingFunction.class);
    private transient boolean trigger;
    private transient int count;
    private transient boolean warned = false;
    private Boolean newPageState;
    private int numberOfElements = 1;
    private String element;
    private boolean initialState;
    private Color visibleBackground;
    private Color invisibleBackground;
    private boolean rowbandingOnGroup;
    private boolean ignoreCrosstabMode;
    private String group;

    @Override
    public void pageStarted(ReportEvent event) {
        if (this.newPageState != null) {
            this.trigger = this.newPageState == false;
            this.count = 0;
            this.triggerVisibleState(event);
        }
    }

    @Override
    public void pageFinished(ReportEvent event) {
    }

    @Override
    public void reportInitialized(ReportEvent event) {
        this.rowbandingOnGroup = this.ignoreCrosstabMode ? !StringUtils.isEmpty((String)this.group) : (FunctionUtilities.isCrosstabDefined(event) ? true : !StringUtils.isEmpty((String)this.group));
        this.trigger = !this.getInitialState();
        this.count = 0;
    }

    @Override
    public void itemsStarted(ReportEvent event) {
        if (!this.rowbandingOnGroup) {
            this.trigger = !this.getInitialState();
            this.count = 0;
        }
    }

    @Override
    public void itemsAdvanced(ReportEvent event) {
        if (!this.rowbandingOnGroup && StringUtils.isEmpty((String)this.group)) {
            this.triggerVisibleState(event);
        }
    }

    @Override
    public void groupStarted(ReportEvent event) {
        if (!this.rowbandingOnGroup) {
            return;
        }
        if (StringUtils.isEmpty((String)this.group)) {
            GroupBody body;
            Group group = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
            if (group instanceof CrosstabRowGroup && (body = group.getBody()) instanceof CrosstabColumnGroupBody) {
                this.triggerVisibleStateCrosstab(event);
            }
        } else if (FunctionUtilities.isDefinedGroup(this.group, event)) {
            this.triggerVisibleStateCrosstab(event);
        }
    }

    private void triggerVisibleState(ReportEvent event) {
        if (this.numberOfElements == 0) {
            return;
        }
        if (this.count % this.numberOfElements == 0) {
            this.trigger = !this.trigger;
        }
        ++this.count;
        ItemBand itemBand = event.getReport().getItemBand();
        if (itemBand == null) {
            return;
        }
        if (this.element == null) {
            if (this.trigger) {
                itemBand.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, this.visibleBackground);
            } else {
                itemBand.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, this.invisibleBackground);
            }
        } else {
            Element[] e = FunctionUtilities.findAllElements(itemBand, this.getElement());
            if (e.length > 0) {
                for (int i = 0; i < e.length; ++i) {
                    if (this.trigger) {
                        e[i].getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, this.visibleBackground);
                        continue;
                    }
                    e[i].getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, this.invisibleBackground);
                }
            } else if (!this.warned) {
                logger.warn((Object)("The Band does not contain an element named " + this.getElement()));
                this.warned = true;
            }
        }
    }

    private void triggerVisibleStateCrosstab(ReportEvent event) {
        if (this.count % this.numberOfElements == 0) {
            this.trigger = !this.trigger;
        }
        ++this.count;
        CrosstabCellBody cellBody = event.getReport().getCrosstabCellBody();
        if (cellBody == null) {
            return;
        }
        if (this.element == null) {
            int elementCount = cellBody.getElementCount();
            for (int i = 1; i < elementCount; ++i) {
                Element cell = cellBody.getElement(i);
                if (this.trigger) {
                    cell.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, this.visibleBackground);
                    continue;
                }
                cell.getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, this.invisibleBackground);
            }
        } else {
            Element[] e = FunctionUtilities.findAllElements(cellBody, this.getElement());
            if (e.length > 0) {
                for (int i = 0; i < e.length; ++i) {
                    if (this.trigger) {
                        e[i].getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, this.visibleBackground);
                        continue;
                    }
                    e[i].getStyle().setStyleProperty(ElementStyleKeys.BACKGROUND_COLOR, this.invisibleBackground);
                }
            } else if (!this.warned) {
                logger.warn((Object)("The cell-body does not contain an element named " + this.getElement()));
                this.warned = true;
            }
        }
    }

    @Override
    public void summaryRowSelection(ReportEvent event) {
        Group group;
        if (!this.rowbandingOnGroup) {
            return;
        }
        if (StringUtils.isEmpty((String)this.group)) {
            GroupBody body;
            Group group2 = event.getReport().getGroup(event.getState().getCurrentGroupIndex());
            if (group2 instanceof CrosstabRowGroup && (body = group2.getBody()) instanceof CrosstabColumnGroupBody && Boolean.TRUE.equals(group2.getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "print-summary"))) {
                this.triggerVisibleStateCrosstab(event);
            }
        } else if (FunctionUtilities.isDefinedGroup(this.group, event) && Boolean.TRUE.equals((group = event.getReport().getGroup(event.getState().getCurrentGroupIndex())).getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/crosstab", "print-summary"))) {
            this.triggerVisibleStateCrosstab(event);
        }
    }

    public boolean isIgnoreCrosstabMode() {
        return this.ignoreCrosstabMode;
    }

    public void setIgnoreCrosstabMode(boolean ignoreCrosstabMode) {
        this.ignoreCrosstabMode = ignoreCrosstabMode;
    }

    public Color getInvisibleBackground() {
        return this.invisibleBackground;
    }

    public void setInvisibleBackground(Color invisibleBackground) {
        this.invisibleBackground = invisibleBackground;
    }

    public Color getVisibleBackground() {
        return this.visibleBackground;
    }

    public void setVisibleBackground(Color visibleBackground) {
        this.visibleBackground = visibleBackground;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public void setNumberOfElements(int numberOfElements) {
        this.numberOfElements = numberOfElements;
    }

    public boolean getInitialState() {
        return this.initialState;
    }

    public void setInitialState(boolean initialState) {
        this.initialState = initialState;
    }

    public void setElement(String name) {
        this.element = name;
    }

    public String getElement() {
        return this.element;
    }

    public String getGroup() {
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public Boolean getNewPageState() {
        return this.newPageState;
    }

    public void setNewPageState(Boolean newPageState) {
        this.newPageState = newPageState;
    }

    @Override
    public Object getValue() {
        if (this.trigger) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

