/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.function.sys;

import java.io.IOException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.ReportDefinition;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.event.ReportEvent;
import org.pentaho.reporting.engine.classic.core.function.AbstractElementFormatFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.FunctionUtilities;
import org.pentaho.reporting.engine.classic.core.function.StructureFunction;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.beans.ConverterRegistry;
import org.pentaho.reporting.engine.classic.core.util.beans.ValueConverter;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.formula.ErrorValue;

public class StyleExpressionsEvaluator
extends AbstractElementFormatFunction
implements StructureFunction {
    private static final Log logger = LogFactory.getLog(StyleExpressionsEvaluator.class);
    private boolean failOnErrors;

    @Override
    public void reportInitialized(ReportEvent event) {
        this.failOnErrors = "true".equals(this.getRuntime().getConfiguration().getConfigProperty("org.pentaho.reporting.engine.classic.core.FailOnStyleExpressionErrors"));
        if (!FunctionUtilities.isLayoutLevel(event)) {
            return;
        }
        super.reportInitialized(event);
        if (!event.getState().isSubReportEvent()) {
            ReportDefinition definition = event.getReport();
            this.evaluateElement(definition);
        }
    }

    @Override
    public int getProcessingPriority() {
        return 10000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean evaluateElement(ReportElement e) {
        Map<StyleKey, Expression> styleExpressions = e.getStyleExpressions();
        if (styleExpressions.isEmpty()) {
            return false;
        }
        boolean retval = false;
        ElementStyleSheet style = e.getStyle();
        for (Map.Entry<StyleKey, Expression> entry : styleExpressions.entrySet()) {
            StyleKey key = entry.getKey();
            Expression ex = entry.getValue();
            if (ex == null) continue;
            retval = true;
            ex.setRuntime(this.getRuntime());
            try {
                Object value = this.evaluate(ex);
                if (value == null) {
                    style.setStyleProperty(key, null);
                    continue;
                }
                if (key.getValueType().isInstance(value)) {
                    style.setStyleProperty(key, value);
                    continue;
                }
                if (value instanceof ErrorValue) {
                    if (this.failOnErrors) {
                        throw new InvalidReportStateException(String.format("Failed to evaluate style-expression for key %s on element [%s]", key.getName(), FunctionUtilities.computeElementLocation(e)));
                    }
                    style.setStyleProperty(key, null);
                    continue;
                }
                ValueConverter valueConverter = ConverterRegistry.getInstance().getValueConverter(key.getValueType());
                if (valueConverter != null) {
                    Object o = ConverterRegistry.toPropertyValue(String.valueOf(value), key.getValueType());
                    style.setStyleProperty(key, o);
                    continue;
                }
                style.setStyleProperty(key, null);
            }
            catch (InvalidReportStateException exception) {
                throw exception;
            }
            catch (Exception exception) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)String.format("Failed to evaluate style expression for element '%s', style-key %s", e, key), (Throwable)exception);
                }
                if (this.failOnErrors) {
                    throw new InvalidReportStateException(String.format("Failed to evaluate style-expression for key %s on element [%s]", key.getName(), FunctionUtilities.computeElementLocation(e)), exception);
                }
                style.setStyleProperty(key, null);
            }
            finally {
                ex.setRuntime(null);
            }
        }
        return retval;
    }

    private Object evaluate(Expression ex) throws IOException, SQLException {
        Object retval = ex.getValue();
        if (retval instanceof Clob) {
            return IOUtils.getInstance().readClob((Clob)retval);
        }
        if (retval instanceof Blob) {
            return IOUtils.getInstance().readBlob((Blob)retval);
        }
        return retval;
    }
}

