/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.model.table.rows;

import org.pentaho.reporting.engine.classic.core.layout.model.Border;
import org.pentaho.reporting.engine.classic.core.layout.model.table.rows.TableRow;
import org.pentaho.reporting.engine.classic.core.util.LongList;

public class TableRowImpl
implements TableRow {
    private Border border;
    private long preferredSize;
    private long validateSize;
    private LongList preferredSizes;
    private long validatedLeadingSize;
    private LongList validatedTrailingSize;

    public TableRowImpl() {
        this(Border.EMPTY_BORDER);
    }

    public TableRowImpl(Border border) {
        this.border = border;
        this.preferredSizes = new LongList(10);
        this.validatedLeadingSize = 0L;
        this.validatedTrailingSize = new LongList(10);
    }

    @Override
    public long getPreferredSize() {
        return this.preferredSize;
    }

    public void setPreferredSize(long preferredSize) {
        this.preferredSize = preferredSize;
    }

    @Override
    public long getPreferredSize(int colspan) {
        int index = colspan - 1;
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (this.preferredSizes.size() <= index) {
            return 0L;
        }
        return this.preferredSizes.get(index);
    }

    public void updateDefinedSize(int rowSpan, long preferredHeight) {
        if (rowSpan < 1) {
            throw new IllegalArgumentException();
        }
        int idx = rowSpan - 1;
        if (idx >= this.preferredSizes.size() || this.preferredSizes.get(idx) < preferredHeight) {
            this.preferredSizes.set(idx, preferredHeight);
        }
    }

    @Override
    public long getValidatedLeadingSize() {
        return this.validatedLeadingSize;
    }

    @Override
    public long getValidatedTrailingSize(int rowSpan) {
        if (rowSpan > this.validatedTrailingSize.size()) {
            return 0L;
        }
        return this.validatedTrailingSize.get(rowSpan - 1);
    }

    @Override
    public int getMaxValidatedRowSpan() {
        return this.validatedTrailingSize.size();
    }

    public void updateValidatedSize(int rowSpan, long leading, long trailing) {
        int idx = rowSpan - 1;
        if (this.validatedLeadingSize < leading) {
            this.validatedLeadingSize = leading;
        }
        if (idx >= this.validatedTrailingSize.size() || this.validatedTrailingSize.get(idx) < trailing) {
            this.validatedTrailingSize.set(idx, trailing);
        }
    }

    @Override
    public long getValidateSize() {
        return this.validateSize;
    }

    public void setValidateSize(long validateSize) {
        this.validateSize = validateSize;
    }

    @Override
    public Border getBorder() {
        return this.border;
    }

    public void clear() {
        this.validatedTrailingSize.clear();
        this.validateSize = 0L;
    }

    @Override
    public int getMaximumRowSpan() {
        return this.preferredSizes.size();
    }

    public String toString() {
        return "TableRowImpl{preferredSize=" + this.preferredSize + ", validateSize=" + this.validateSize + ", preferredSizes=" + this.preferredSizes + ", validatedLeadingSize=" + this.validatedLeadingSize + ", validatedTrailingSize=" + this.validatedTrailingSize + ", border=" + this.border + '}';
    }
}

