/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.process;

import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PageGrid;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableCellRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.TableRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.table.columns.TableColumnModel;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.process.IterateVisualProcessStep;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.CenterAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.JustifyAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.LeftAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.RightAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.alignment.TextAlignmentProcessor;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisNodeContext;
import org.pentaho.reporting.engine.classic.core.layout.process.util.MinorAxisTableContext;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;

public abstract class AbstractMinorAxisLayoutStep
extends IterateVisualProcessStep {
    public static final long OVERFLOW_DUMMY_WIDTH = StrictGeomUtility.toInternalValue(20000.0);
    private OutputProcessorMetaData metaData;
    private boolean strictLegacyMode;
    private PageGrid pageGrid;
    private TextAlignmentProcessor centerProcessor;
    private TextAlignmentProcessor rightProcessor;
    private TextAlignmentProcessor leftProcessor;
    private TextAlignmentProcessor justifyProcessor;
    private MinorAxisTableContext tableContext;

    protected AbstractMinorAxisLayoutStep() {
    }

    public void initialize(OutputProcessorMetaData metaData) {
        this.metaData = metaData;
        this.strictLegacyMode = metaData.isFeatureSupported(OutputProcessorFeature.STRICT_COMPATIBILITY);
    }

    protected OutputProcessorMetaData getMetaData() {
        return this.metaData;
    }

    protected boolean isStrictLegacyMode() {
        return this.strictLegacyMode;
    }

    protected PageGrid getPageGrid() {
        return this.pageGrid;
    }

    protected boolean checkCacheValid(RenderNode node) {
        RenderNode.CacheState cacheState = node.getCacheState();
        return cacheState == RenderNode.CacheState.CLEAN;
    }

    public void compute(LogicalPageBox root) {
        this.getEventWatch().start();
        this.getSummaryWatch().start();
        try {
            this.pageGrid = root.getPageGrid();
            this.startProcessing(root);
        }
        finally {
            this.pageGrid = null;
            this.getEventWatch().stop();
            this.getSummaryWatch().stop(true);
        }
    }

    protected abstract MinorAxisNodeContext getNodeContext();

    protected TextAlignmentProcessor create(ElementAlignment alignment) {
        if (ElementAlignment.CENTER.equals(alignment)) {
            if (this.centerProcessor == null) {
                this.centerProcessor = new CenterAlignmentProcessor();
            }
            return this.centerProcessor;
        }
        if (ElementAlignment.RIGHT.equals(alignment)) {
            if (this.rightProcessor == null) {
                this.rightProcessor = new RightAlignmentProcessor();
            }
            return this.rightProcessor;
        }
        if (ElementAlignment.JUSTIFY.equals(alignment)) {
            if (this.justifyProcessor == null) {
                this.justifyProcessor = new JustifyAlignmentProcessor();
            }
            return this.justifyProcessor;
        }
        if (this.leftProcessor == null) {
            this.leftProcessor = new LeftAlignmentProcessor();
        }
        return this.leftProcessor;
    }

    protected void startTableContext(RenderBox box) {
        if (box.getNodeType() == 266242) {
            if (this.isStrictLegacyMode()) {
                throw new InvalidReportStateException("A report with a legacy mode of pre-4.0 cannot handle table layouts. Migrate your report to at least version 4.0.");
            }
            this.tableContext = new MinorAxisTableContext((TableRenderBox)box, this.tableContext);
        }
    }

    protected boolean finishTableContext(RenderBox box) {
        if (box.getNodeType() != 266242) {
            return false;
        }
        TableColumnModel columnModel = this.tableContext.getTable().getColumnModel();
        if (!this.tableContext.isStructureValidated()) {
            columnModel.validateSizes((TableRenderBox)box);
            this.tableContext.setStructureValidated(true);
        }
        box.setCachedWidth(columnModel.getCachedSize());
        this.tableContext = this.tableContext.pop();
        return true;
    }

    public MinorAxisTableContext getTableContext() {
        return this.tableContext;
    }

    protected long computeCellWidth(TableCellRenderBox tableCellRenderBox) {
        MinorAxisTableContext tableContext = this.getTableContext();
        int columnIndex = tableCellRenderBox.getColumnIndex();
        TableColumnModel columnModel = tableContext.getColumnModel();
        int colSpan = tableCellRenderBox.getColSpan();
        if (colSpan <= 0) {
            throw new InvalidReportStateException("A cell cannot have a col-span of zero or less");
        }
        long cellSizeFromModel = 0L;
        for (int i = 0; i < colSpan; ++i) {
            cellSizeFromModel += columnModel.getEffectiveColumnSize(columnIndex + i);
            cellSizeFromModel += columnModel.getBorderSpacing();
        }
        return cellSizeFromModel -= columnModel.getBorderSpacing();
    }

    @Override
    protected boolean startTableColLevelBox(RenderBox box) {
        return false;
    }
}

