/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.style;

import java.util.List;
import org.pentaho.reporting.engine.classic.core.style.AbstractStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementDefaultStyleSheet;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class ParagraphPoolboxStyleSheet
extends AbstractStyleSheet {
    private StyleSheet parentStyleSheet;
    private StyleSheet defaultStyleSheet;

    public ParagraphPoolboxStyleSheet(StyleSheet parentStyleSheet) {
        if (parentStyleSheet == null) {
            throw new NullPointerException();
        }
        this.parentStyleSheet = parentStyleSheet;
        this.defaultStyleSheet = ElementDefaultStyleSheet.getDefaultStyle();
    }

    @Override
    public Object getStyleProperty(StyleKey key, Object defaultValue) {
        if (ElementStyleKeys.AVOID_PAGEBREAK_INSIDE.equals(key)) {
            return Boolean.TRUE;
        }
        if (key.isInheritable()) {
            return this.parentStyleSheet.getStyleProperty(key, defaultValue);
        }
        return this.defaultStyleSheet.getStyleProperty(key, defaultValue);
    }

    public StyleSheet getParent() {
        return this.parentStyleSheet;
    }

    @Override
    public InstanceID getId() {
        return this.parentStyleSheet.getId();
    }

    @Override
    public long getChangeTracker() {
        return this.parentStyleSheet.getChangeTracker();
    }

    @Override
    public Object[] toArray() {
        Object[] objects = this.defaultStyleSheet.toArray();
        List<StyleKey> keys = StyleKey.getDefinedStyleKeysList();
        int len = keys.size();
        for (int i = 0; i < len; ++i) {
            StyleKey key = keys.get(i);
            if (ElementStyleKeys.AVOID_PAGEBREAK_INSIDE.equals(key)) {
                objects[i] = Boolean.TRUE;
                continue;
            }
            if (!key.isInheritable()) continue;
            objects[i] = this.parentStyleSheet.getStyleProperty(key, null);
        }
        return objects;
    }
}

