/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.layout.text;

import org.pentaho.reporting.engine.classic.core.layout.text.Glyph;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.text.Spacing;

public final class GlyphList {
    protected static final int EXTRA_GLYPH_INFO = 7;
    protected static final int[] EMPTY_INTS = new int[0];
    private int[] glyphSequenceData;
    private Spacing[] spacings;
    private int[] glyphIndices;
    private int glyphSequenceFill;
    private int glyphIncrement;
    private int size;
    private int spacerIncrement;
    private VirtualGlyph virtualGlyph;
    private boolean locked;
    private StringBuilder stringBuilder;

    private GlyphList() {
        this.virtualGlyph = new VirtualGlyph(this);
    }

    public GlyphList(int spacerIncrement) {
        this(spacerIncrement * 8, spacerIncrement);
    }

    public GlyphList(int glyphIncrement, int spacerIncrement) {
        this.glyphIncrement = glyphIncrement;
        this.spacerIncrement = spacerIncrement;
        this.virtualGlyph = new VirtualGlyph(this);
        this.glyphIndices = new int[spacerIncrement];
        this.spacings = new Spacing[spacerIncrement];
        this.glyphSequenceData = new int[glyphIncrement];
    }

    protected int[] getGlyphSequenceData() {
        return this.glyphSequenceData;
    }

    protected Spacing[] getSpacings() {
        return this.spacings;
    }

    private void ensureGlyphCapacity(int capacity) {
        if (this.glyphSequenceData.length <= capacity) {
            int[] newData = new int[Math.max(this.glyphSequenceData.length + this.glyphIncrement, capacity + 1)];
            System.arraycopy(this.glyphSequenceData, 0, newData, 0, this.glyphSequenceFill);
            this.glyphSequenceData = newData;
        }
    }

    private void ensureSpacerCapacity(int capacity) {
        if (this.spacings.length <= capacity) {
            Spacing[] newData = new Spacing[Math.max(this.spacings.length + this.spacerIncrement, capacity + 1)];
            System.arraycopy(this.spacings, 0, newData, 0, this.size);
            this.spacings = newData;
            int[] newIndexData = new int[Math.max(this.glyphIndices.length + this.spacerIncrement, capacity + 1)];
            System.arraycopy(this.glyphIndices, 0, newIndexData, 0, this.size);
            this.glyphIndices = newIndexData;
        }
    }

    public void addGlyphData(int[] rawCodepoints, int rawCodePointOffset, int rawCodePointLength, int breakWeight, int classification, Spacing spacing, int width, int height, int baseLine, int kerning) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.ensureGlyphCapacity(this.glyphSequenceFill + rawCodePointLength + 7);
        this.ensureSpacerCapacity(this.size + 1);
        int glyphSequenceFill = this.glyphSequenceFill;
        this.glyphSequenceData[glyphSequenceFill] = rawCodePointLength - 1;
        this.glyphSequenceData[glyphSequenceFill + 1] = breakWeight;
        this.glyphSequenceData[glyphSequenceFill + 2] = classification;
        this.glyphSequenceData[glyphSequenceFill + 3] = width;
        this.glyphSequenceData[glyphSequenceFill + 4] = height;
        this.glyphSequenceData[glyphSequenceFill + 5] = baseLine;
        this.glyphSequenceData[glyphSequenceFill + 6] = kerning;
        if (rawCodePointLength == 1) {
            this.glyphSequenceData[glyphSequenceFill + 7] = rawCodepoints[rawCodePointOffset];
        } else {
            System.arraycopy(rawCodepoints, rawCodePointOffset, this.glyphSequenceData, glyphSequenceFill + 7, rawCodePointLength);
        }
        this.glyphSequenceFill = glyphSequenceFill + 7 + rawCodePointLength;
        this.glyphIndices[this.size] = glyphSequenceFill;
        this.spacings[this.size] = spacing;
        ++this.size;
    }

    public Glyph getGlyph(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException();
        }
        this.virtualGlyph.update(this.glyphIndices[index], index);
        return this.virtualGlyph;
    }

    public int getSize() {
        return this.size;
    }

    public GlyphList lock() {
        GlyphList retval = new GlyphList();
        retval.spacerIncrement = 0;
        retval.glyphIncrement = 0;
        retval.locked = true;
        retval.glyphSequenceFill = this.glyphSequenceFill;
        retval.glyphSequenceData = new int[this.glyphSequenceFill];
        System.arraycopy(this.glyphSequenceData, 0, retval.glyphSequenceData, 0, this.glyphSequenceFill);
        retval.size = this.size;
        retval.spacings = new Spacing[this.size];
        retval.glyphIndices = new int[this.size];
        System.arraycopy(this.spacings, 0, retval.spacings, 0, this.size);
        System.arraycopy(this.glyphIndices, 0, retval.glyphIndices, 0, this.size);
        return retval;
    }

    public void clear() {
        this.size = 0;
        this.glyphSequenceFill = 0;
    }

    public void ensureSize(int size) {
        this.ensureSpacerCapacity(size);
        this.ensureGlyphCapacity(size * 8);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public String getText(int offset, int length, CodePointBuffer codePointBuffer) {
        if (length == 0) {
            return "";
        }
        codePointBuffer.setCursor(0);
        StringBuilder cps = this.create();
        int maxPos = offset + length;
        for (int i = offset; i < maxPos; ++i) {
            int glyphIndex = this.glyphIndices[i];
            int glyphDataStart = glyphIndex + 7;
            int glyphDataEnd = glyphDataStart + this.glyphSequenceData[glyphIndex] + 1;
            for (int g = glyphDataStart; g < glyphDataEnd; ++g) {
                this.encodeStringIncrementally(cps, this.glyphSequenceData[g]);
            }
        }
        String retval = cps.toString();
        cps.delete(0, cps.length());
        return retval;
    }

    private StringBuilder create() {
        if (this.stringBuilder == null) {
            this.stringBuilder = new StringBuilder();
        }
        this.stringBuilder.delete(0, this.stringBuilder.length());
        return this.stringBuilder;
    }

    private void encodeStringIncrementally(StringBuilder stringBuffer, int codePoint) {
        if (codePoint < 65536) {
            stringBuffer.append((char)codePoint);
        } else {
            int derivedSourceItem = codePoint - 65536;
            int highWord = 0xD800 | (derivedSourceItem & 0xFFC00) >> 10;
            int lowWord = 0xDC00 | derivedSourceItem & 0x3FF;
            stringBuffer.append((char)highWord);
            stringBuffer.append((char)lowWord);
        }
    }

    public String getGlyphAsString(int index, CodePointBuffer codePointBuffer) {
        codePointBuffer.setCursor(0);
        StringBuilder cps = this.create();
        int glyphIndex = this.glyphIndices[index];
        int glyphDataStart = glyphIndex + 7;
        int glyphDataEnd = glyphDataStart + this.glyphSequenceData[glyphIndex] + 1;
        for (int g = glyphDataStart; g < glyphDataEnd; ++g) {
            this.encodeStringIncrementally(cps, this.glyphSequenceData[g]);
        }
        String retval = cps.toString();
        cps.delete(0, cps.length());
        return retval;
    }

    public String toString() {
        return "GlyphList={text='" + this.getText(0, this.size, new CodePointBuffer(this.size)) + "'}";
    }

    private static class VirtualGlyph
    implements Glyph {
        private int index;
        private int spacingIndex;
        private int extraGlyphCount;
        private int[] glyphData;
        private GlyphList parent;

        private VirtualGlyph(GlyphList parent) {
            this.parent = parent;
        }

        public void update(int glyphDataIndex, int spacingIndex) {
            this.index = glyphDataIndex;
            this.spacingIndex = spacingIndex;
            this.glyphData = this.parent.getGlyphSequenceData();
            this.extraGlyphCount = this.glyphData[this.index];
        }

        @Override
        public int getClassification() {
            return this.glyphData[this.index + 2];
        }

        @Override
        public int[] getExtraChars() {
            if (this.extraGlyphCount == 0) {
                return EMPTY_INTS;
            }
            int[] retal = new int[this.extraGlyphCount];
            System.arraycopy(this.glyphData, this.index + 7 + 1, retal, 0, this.extraGlyphCount);
            return retal;
        }

        @Override
        public int getBaseLine() {
            return this.glyphData[this.index + 5];
        }

        @Override
        public int getCodepoint() {
            return this.glyphData[this.index + 7];
        }

        @Override
        public int getBreakWeight() {
            return this.glyphData[this.index + 1];
        }

        @Override
        public Spacing getSpacing() {
            Spacing[] spacings1 = this.parent.getSpacings();
            return spacings1[this.spacingIndex];
        }

        @Override
        public int getWidth() {
            return this.glyphData[this.index + 3];
        }

        @Override
        public int getHeight() {
            return this.glyphData[this.index + 4];
        }

        @Override
        public int getKerning() {
            return this.glyphData[this.index + 6];
        }
    }
}

