/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.MetaDataLookupException;
import org.pentaho.reporting.engine.classic.core.metadata.parser.DataFactoryMetaDataCollection;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class DataFactoryRegistry {
    private static final Log logger = LogFactory.getLog(DataFactoryRegistry.class);
    private static DataFactoryRegistry instance;
    private LinkedHashMap<String, DataFactoryMetaData> backend;
    private ResourceManager resourceManager = new ResourceManager();

    public static synchronized DataFactoryRegistry getInstance() {
        if (instance == null) {
            instance = new DataFactoryRegistry();
        }
        return instance;
    }

    private DataFactoryRegistry() {
        this.backend = new LinkedHashMap();
    }

    public void registerFromXml(URL dataFactoryMetaSource) throws IOException {
        if (dataFactoryMetaSource == null) {
            throw new NullPointerException("Error: Could not find the data-factory meta-data description file");
        }
        try {
            Resource resource = this.resourceManager.createDirectly((Object)dataFactoryMetaSource, DataFactoryMetaDataCollection.class);
            DataFactoryMetaDataCollection typeCollection = (DataFactoryMetaDataCollection)resource.getResource();
            DataFactoryMetaData[] types = typeCollection.getFactoryMetaData();
            for (int i = 0; i < types.length; ++i) {
                DataFactoryMetaData metaData = types[i];
                if (metaData == null) continue;
                this.register(metaData);
            }
        }
        catch (Exception e) {
            logger.error((Object)"Failed:", (Throwable)e);
            throw new IOException("Error: Could not parse the element meta-data description file");
        }
    }

    public void unregister(DataFactoryMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.backend.remove(metaData.getName());
    }

    public void register(DataFactoryMetaData metaData) {
        if (metaData == null) {
            throw new NullPointerException();
        }
        this.backend.put(metaData.getName(), metaData);
    }

    public DataFactoryMetaData[] getAll() {
        return this.backend.values().toArray(new DataFactoryMetaData[this.backend.size()]);
    }

    public boolean isRegistered(String identifier) {
        if (identifier == null) {
            throw new NullPointerException();
        }
        return this.backend.containsKey(identifier);
    }

    public DataFactoryMetaData getMetaData(String identifier) throws MetaDataLookupException {
        if (identifier == null) {
            throw new NullPointerException();
        }
        DataFactoryMetaData retval = this.backend.get(identifier);
        if (retval == null) {
            throw new MetaDataLookupException("Unable to locate metadata for data-factory type " + identifier);
        }
        return retval;
    }
}

