/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.HashMap;

public class SharedBeanInfo {
    private Class beanClass;
    private BeanInfo beanInfo;
    private HashMap<String, PropertyDescriptor> propertyDescriptors;

    public SharedBeanInfo(Class beanClass) {
        this.beanClass = beanClass;
    }

    public Class getBeanClass() {
        return this.beanClass;
    }

    public BeanInfo getBeanInfo() {
        if (this.beanInfo == null) {
            this.propertyDescriptors = new HashMap();
            try {
                this.beanInfo = Introspector.getBeanInfo(this.beanClass);
                PropertyDescriptor[] descriptors = this.beanInfo.getPropertyDescriptors();
                for (int i = 0; i < descriptors.length; ++i) {
                    PropertyDescriptor descriptor = descriptors[i];
                    this.propertyDescriptors.put(descriptor.getName(), descriptor);
                }
            }
            catch (IntrospectionException e) {
                throw new IllegalStateException("Cannot introspect specified " + this.beanClass);
            }
        }
        return this.beanInfo;
    }

    public PropertyDescriptor getPropertyDescriptor(String name) {
        if (this.beanInfo == null) {
            this.getBeanInfo();
        }
        return this.propertyDescriptors.get(name);
    }
}

