/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.builder;

import java.util.LinkedHashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.metadata.ExpressionPropertyMetaData;
import org.pentaho.reporting.engine.classic.core.metadata.builder.MetaDataBuilder;

public class ExpressionMetaDataBuilder
extends MetaDataBuilder<ExpressionMetaDataBuilder> {
    private Class<? extends Expression> impl;
    private Class<?> resultType = Object.class;
    private LinkedHashMap<String, ExpressionPropertyMetaData> properties = new LinkedHashMap();
    private int layoutComputation = 0;

    @Override
    protected ExpressionMetaDataBuilder self() {
        return this;
    }

    public ExpressionMetaDataBuilder impl(Class<? extends Expression> expressionClass) {
        this.impl = expressionClass;
        return this.self();
    }

    @Override
    public String getName() {
        if (this.impl == null) {
            return null;
        }
        return this.impl.getName();
    }

    public ExpressionMetaDataBuilder resultType(Class<?> resultType) {
        this.resultType = resultType;
        return this.self();
    }

    public ExpressionMetaDataBuilder properties(Map<String, ExpressionPropertyMetaData> properties) {
        this.properties.putAll(properties);
        return this.self();
    }

    public ExpressionMetaDataBuilder property(ExpressionPropertyMetaData p) {
        this.properties.put(p.getName(), p);
        return this.self();
    }

    public ExpressionMetaDataBuilder layoutComputation(int layoutComputation) {
        this.layoutComputation = layoutComputation;
        return this.self();
    }

    public Class<? extends Expression> getImpl() {
        return this.impl;
    }

    public Class<?> getResultType() {
        return this.resultType;
    }

    public LinkedHashMap<String, ExpressionPropertyMetaData> getProperties() {
        return this.properties;
    }

    public int getLayoutComputation() {
        return this.layoutComputation;
    }
}

