/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.metadata.propertyeditors;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.util.TreeSet;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;

public class CompatibilityLevelPropertyEditor
implements PropertyEditor {
    private String[] TAGS = new String[]{null, "3.8.0", "3.8.3", "3.9.0", "3.9.1", "4.0.0"};
    private int[] TAG_MAP = new int[]{-1, ClassicEngineBoot.computeVersionId(3, 8, 0), ClassicEngineBoot.computeVersionId(3, 8, 3), ClassicEngineBoot.computeVersionId(3, 9, 0), ClassicEngineBoot.computeVersionId(3, 9, 1), ClassicEngineBoot.computeVersionId(4, 0, 0)};
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private Integer value;

    @Override
    public void setValue(Object value) {
        if (value == null || value instanceof Integer) {
            Integer oldValue = this.value;
            this.value = (Integer)value;
            this.propertyChangeSupport.firePropertyChange((String)null, oldValue, this.value);
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public String getAsText() {
        if (this.value == null) {
            return null;
        }
        int ix = this.value;
        for (int i = 0; i < this.TAG_MAP.length; ++i) {
            if (this.TAG_MAP[i] != ix) continue;
            return this.TAGS[i];
        }
        if (ix < 0) {
            return null;
        }
        return ClassicEngineBoot.printVersion(this.value);
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        int i;
        if (text == null) {
            this.setValue(null);
            return;
        }
        for (i = 0; i < this.TAGS.length; ++i) {
            if (!text.equals(this.TAGS[i])) continue;
            this.setValue(this.TAG_MAP[i]);
            return;
        }
        i = ClassicEngineBoot.parseVersionId(text);
        if (i != -1) {
            this.setValue(i);
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String[] getTags() {
        String asText = this.getAsText();
        if (asText == null) {
            return (String[])this.TAGS.clone();
        }
        TreeSet<String> tags = new TreeSet<String>();
        for (String s : this.TAGS) {
            if (s == null) continue;
            tags.add(s);
        }
        tags.add(asText);
        String[] retval = new String[tags.size() + 1];
        System.arraycopy(tags.toArray(new String[tags.size()]), 0, retval, 1, tags.size());
        return retval;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public String getJavaInitializationString() {
        return String.valueOf(this.value);
    }
}

