/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.gui.print;

import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.PrintReportProcessor;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;

public class PrintUtil {
    private static final Log logger = LogFactory.getLog(PrintUtil.class);
    public static final String PRINTER_JOB_NAME_KEY = "org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.print.JobName";
    public static final String NUMBER_COPIES_KEY = "org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.print.NumberOfCopies";

    private PrintUtil() {
    }

    public static void printDirectly(MasterReport report) throws PrinterException, ReportProcessingException {
        PrintUtil.printDirectly(report, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printDirectly(MasterReport report, ReportProgressListener progressListener) throws PrinterException, ReportProcessingException {
        ModifiableConfiguration reportConfiguration = report.getReportConfiguration();
        String jobName = reportConfiguration.getConfigProperty(PRINTER_JOB_NAME_KEY, report.getTitle());
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (jobName != null) {
            printerJob.setJobName(jobName);
        }
        PrintReportProcessor reportPane = new PrintReportProcessor(report);
        if (progressListener != null) {
            reportPane.addReportProgressListener(progressListener);
        }
        printerJob.setPageable(reportPane);
        try {
            printerJob.setCopies(PrintUtil.getNumberOfCopies((Configuration)reportConfiguration));
            printerJob.print();
        }
        finally {
            reportPane.close();
            if (progressListener != null) {
                reportPane.removeReportProgressListener(progressListener);
            }
        }
    }

    public static boolean print(MasterReport report) throws PrinterException, ReportProcessingException {
        return PrintUtil.print(report, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean print(MasterReport report, ReportProgressListener progressListener) throws PrinterException, ReportProcessingException {
        ModifiableConfiguration reportConfiguration = report.getReportConfiguration();
        String jobName = reportConfiguration.getConfigProperty(PRINTER_JOB_NAME_KEY, report.getTitle());
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        if (jobName != null) {
            printerJob.setJobName(jobName);
        }
        PrintReportProcessor reportPane = new PrintReportProcessor(report);
        if (progressListener != null) {
            reportPane.addReportProgressListener(progressListener);
        }
        try {
            reportPane.fireProcessingStarted();
            printerJob.setPageable(reportPane);
            printerJob.setCopies(PrintUtil.getNumberOfCopies((Configuration)reportConfiguration));
            if (printerJob.printDialog()) {
                printerJob.print();
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            reportPane.fireProcessingFinished();
            reportPane.close();
            if (progressListener != null) {
                reportPane.removeReportProgressListener(progressListener);
            }
        }
    }

    public static int getNumberOfCopies(Configuration configuration) {
        try {
            return Math.max(1, Integer.parseInt(configuration.getConfigProperty(NUMBER_COPIES_KEY, "1")));
        }
        catch (Exception e) {
            logger.warn((Object)"PrintUtil: Number of copies declared for the report is invalid");
            return 1;
        }
    }
}

