/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.validator;

import java.util.ArrayList;
import org.pentaho.reporting.engine.classic.core.AbstractReportDefinition;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.ReportElement;
import org.pentaho.reporting.engine.classic.core.RootLevelBand;
import org.pentaho.reporting.engine.classic.core.Section;
import org.pentaho.reporting.engine.classic.core.function.ElementTrafficLightFunction;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.function.ItemHideFunction;
import org.pentaho.reporting.engine.classic.core.function.RowBandingFunction;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.validator.DynamicStyleRootBandAnalyzer;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleKey;
import org.pentaho.reporting.engine.classic.core.util.AbstractStructureVisitor;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;
import org.pentaho.reporting.libraries.base.util.HashNMap;

public class DynamicReportStyleAnalyzer
extends AbstractStructureVisitor {
    private HashNMap<String, StyleKey> styleByElementName = new HashNMap();
    private HashNMap<InstanceID, StyleKey> styleById = new HashNMap();
    private ArrayList<Section> rootBands = new ArrayList();

    public void compute(AbstractReportDefinition report) {
        this.inspect(report);
        DynamicStyleRootBandAnalyzer rootBandAnalyzer = new DynamicStyleRootBandAnalyzer(this.styleByElementName, this.styleById);
        for (Section element : this.rootBands) {
            rootBandAnalyzer.compute(element);
        }
    }

    @Override
    protected void inspectExpression(AbstractReportDefinition report, Expression expression) {
        if (expression instanceof RowBandingFunction) {
            this.handleRowBanding(report, (RowBandingFunction)expression);
        }
        if (expression instanceof ItemHideFunction) {
            this.handleItemHide((ItemHideFunction)expression);
        }
        if (expression instanceof ElementTrafficLightFunction) {
            this.handleTrafficLightFunction((ElementTrafficLightFunction)expression);
        }
    }

    private void handleRowBanding(AbstractReportDefinition report, RowBandingFunction rb) {
        String element = rb.getElement();
        if (element == null) {
            ItemBand itemBand = report.getItemBand();
            if (itemBand != null) {
                this.styleById.add((Object)itemBand.getObjectID(), (Object)ElementStyleKeys.BACKGROUND_COLOR);
            }
        } else {
            this.styleByElementName.add((Object)element, (Object)ElementStyleKeys.BACKGROUND_COLOR);
        }
    }

    private void handleItemHide(ItemHideFunction rb) {
        String element = rb.getElement();
        this.styleByElementName.add((Object)element, (Object)ElementStyleKeys.VISIBLE);
    }

    private void handleTrafficLightFunction(ElementTrafficLightFunction rb) {
        String element = rb.getElement();
        if (element == null) {
            return;
        }
        if (rb.isDefineBackground()) {
            this.styleByElementName.add((Object)element, (Object)ElementStyleKeys.BACKGROUND_COLOR);
        } else {
            this.styleByElementName.add((Object)element, (Object)ElementStyleKeys.PAINT);
        }
    }

    @Override
    protected void traverseSection(Section section) {
        this.traverseSectionWithoutSubReports(section);
    }

    @Override
    protected void inspectElement(ReportElement element) {
        if (element instanceof RootLevelBand && element instanceof Section) {
            this.rootBands.add((Section)element);
        }
    }
}

