/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.fast.xls;

import java.util.ArrayList;
import java.util.HashMap;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderBox;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.CellLayoutInfo;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FastExportTemplateProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.FormattedDataBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.template.TemplatingOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.xls.FastExcelFormattedDataBuilder;
import org.pentaho.reporting.engine.classic.core.modules.output.fast.xls.FastExcelPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.AbstractTableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackground;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellBackgroundProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.CellMarker;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.SheetLayout;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableContentProducer;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.TableRectangle;
import org.pentaho.reporting.engine.classic.core.util.InstanceID;

public class FastExcelTemplateProducer
implements FastExportTemplateProducer {
    private final OutputProcessorMetaData metaData;
    private final SheetLayout sheetLayout;
    private final FastExcelPrinter excelPrinter;
    private final CellBackgroundProducer cellBackgroundProducer;
    private final HashMap<InstanceID, CellLayoutInfo> layout;
    private final ArrayList<CellLayoutInfo> backgroundCells;
    private long[] cellHeights;

    public FastExcelTemplateProducer(OutputProcessorMetaData metaData, SheetLayout sheetLayout, FastExcelPrinter excelPrinter) {
        this.metaData = metaData;
        this.sheetLayout = sheetLayout;
        this.excelPrinter = excelPrinter;
        this.layout = new HashMap();
        this.backgroundCells = new ArrayList();
        this.cellBackgroundProducer = new CellBackgroundProducer(metaData.isFeatureSupported(AbstractTableOutputProcessor.TREAT_ELLIPSE_AS_RECTANGLE), metaData.isFeatureSupported(OutputProcessorFeature.UNALIGNED_PAGEBANDS));
    }

    @Override
    public FormattedDataBuilder createDataBuilder() {
        return new FastExcelFormattedDataBuilder(this.layout, this.backgroundCells, this.cellHeights, this.excelPrinter);
    }

    @Override
    public void produceTemplate(LogicalPageBox pageBox) {
        TableContentProducer contentProducer = TemplatingOutputProcessor.produceTableLayout(pageBox, this.sheetLayout, this.metaData);
        SheetLayout sheetLayout = contentProducer.getSheetLayout();
        int columnCount = contentProducer.getColumnCount();
        int startRow = contentProducer.getFinishedRows();
        int finishRow = contentProducer.getFilledRows();
        this.cellHeights = new long[finishRow - startRow];
        for (int row = startRow; row < finishRow; ++row) {
            this.cellHeights[row - startRow] = sheetLayout.getRowHeight(row);
            for (int col = 0; col < columnCount; col = (int)((short)(col + 1))) {
                CellMarker.SectionType sectionType = contentProducer.getSectionType(row, col);
                RenderBox content = contentProducer.getContent(row, col);
                if (content == null) {
                    RenderBox backgroundBox = contentProducer.getBackground(row, col);
                    CellBackground background = backgroundBox != null ? this.cellBackgroundProducer.getBackgroundForBox(pageBox, sheetLayout, col, row, 1, 1, true, sectionType, backgroundBox) : this.cellBackgroundProducer.getBackgroundAt(pageBox, sheetLayout, col, row, true, sectionType);
                    if (background == null) continue;
                    this.backgroundCells.add(new CellLayoutInfo(col, row, background));
                    continue;
                }
                if (!content.isCommited()) {
                    throw new InvalidReportStateException("Uncommited content encountered");
                }
                long contentOffset = contentProducer.getContentOffset(row, col);
                TableRectangle rect = sheetLayout.getTableBounds(content.getX(), content.getY() + contentOffset, content.getWidth(), content.getHeight(), null);
                if (!rect.isOrigin(col, row)) continue;
                CellBackground bg = this.cellBackgroundProducer.getBackgroundForBox(pageBox, sheetLayout, rect.getX1(), rect.getY1(), rect.getColumnSpan(), rect.getRowSpan(), false, sectionType, content);
                this.layout.put(content.getInstanceId(), new CellLayoutInfo(rect, bg));
                content.setFinishedTable(true);
            }
        }
    }
}

