/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Phrase;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.ColumnText;
import com.lowagie.text.pdf.PdfAction;
import com.lowagie.text.pdf.PdfAnnotation;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfDestination;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfObject;
import com.lowagie.text.pdf.PdfOutline;
import com.lowagie.text.pdf.PdfString;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfTextArray;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ElementAlignment;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.InvalidReportStateException;
import org.pentaho.reporting.engine.classic.core.LocalImageContainer;
import org.pentaho.reporting.engine.classic.core.URLImageContainer;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMap;
import org.pentaho.reporting.engine.classic.core.imagemap.ImageMapEntry;
import org.pentaho.reporting.engine.classic.core.layout.model.InlineRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.LogicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.ParagraphRenderBox;
import org.pentaho.reporting.engine.classic.core.layout.model.PhysicalPageBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderNode;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableComplexText;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableReplacedContentBox;
import org.pentaho.reporting.engine.classic.core.layout.model.RenderableText;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorFeature;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.engine.classic.core.layout.process.text.RichTextSpec;
import org.pentaho.reporting.engine.classic.core.layout.text.Glyph;
import org.pentaho.reporting.engine.classic.core.layout.text.GlyphList;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.internal.LogicalPageDrawable;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal.PdfGraphics2D;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal.PdfImageHandler;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal.PdfOutputProcessorMetaData;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.internal.PolygonAnnotation;
import org.pentaho.reporting.engine.classic.core.style.BandStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.ElementStyleKeys;
import org.pentaho.reporting.engine.classic.core.style.StyleSheet;
import org.pentaho.reporting.engine.classic.core.style.TextDirection;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;
import org.pentaho.reporting.engine.classic.core.util.TypedMapWrapper;
import org.pentaho.reporting.engine.classic.core.util.geom.StrictGeomUtility;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;
import org.pentaho.reporting.libraries.fonts.encoding.CodePointBuffer;
import org.pentaho.reporting.libraries.fonts.itext.BaseFontFontMetrics;
import org.pentaho.reporting.libraries.fonts.registry.FontNativeContext;
import org.pentaho.reporting.libraries.fonts.text.Spacing;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.factory.drawable.DrawableWrapper;

public class PdfLogicalPageDrawable
extends LogicalPageDrawable {
    private static final Log logger = LogFactory.getLog(PdfLogicalPageDrawable.class);
    private static final float ITALIC_ANGLE = 0.21256f;
    private PdfWriter writer;
    private float globalHeight;
    private boolean globalEmbed;
    private LFUMap<ResourceKey, Image> imageCache;
    private char version;
    private PdfImageHandler imageHandler;
    private boolean legacyLineHeightCalc;
    private ParagraphRenderBox paragraphContext;
    private static final float SAFETY_MARGIN = 0.1f;

    public PdfLogicalPageDrawable(PdfWriter writer, LFUMap<ResourceKey, Image> imageCache, char version) {
        if (writer == null) {
            throw new NullPointerException();
        }
        if (imageCache == null) {
            throw new NullPointerException();
        }
        this.writer = writer;
        this.imageCache = imageCache;
        this.version = version;
    }

    @Override
    public void init(LogicalPageBox rootBox, OutputProcessorMetaData metaData, ResourceManager resourceManager) {
        throw new UnsupportedOperationException();
    }

    public void init(LogicalPageBox rootBox, PdfOutputProcessorMetaData metaData, ResourceManager resourceManager, PhysicalPageBox page) {
        super.init(rootBox, metaData, resourceManager);
        this.globalHeight = page != null ? (float)StrictGeomUtility.toExternalValue(page.getHeight() - page.getImageableY() + page.getGlobalY()) : (float)rootBox.getPageHeight();
        this.globalEmbed = this.getMetaData().isFeatureSupported(OutputProcessorFeature.EMBED_ALL_FONTS);
        this.imageHandler = new PdfImageHandler(metaData, resourceManager, this.imageCache);
        this.legacyLineHeightCalc = metaData.isFeatureSupported(OutputProcessorFeature.LEGACY_LINEHEIGHT_CALC);
    }

    @Override
    public PdfOutputProcessorMetaData getMetaData() {
        return (PdfOutputProcessorMetaData)super.getMetaData();
    }

    protected float getGlobalHeight() {
        return this.globalHeight;
    }

    @Override
    public void draw(Graphics2D graphics, Rectangle2D area) {
        super.draw(graphics, area);
    }

    @Override
    protected void processLinksAndAnchors(RenderNode box) {
        String bookmark;
        String anchor;
        StyleSheet styleSheet = box.getStyleSheet();
        if (!this.drawPdfScript(box)) {
            String target = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TARGET);
            String title = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_TITLE);
            if (target != null || title != null) {
                String window = (String)styleSheet.getStyleProperty(ElementStyleKeys.HREF_WINDOW);
                this.drawHyperlink(box, target, window, title);
            }
        }
        if ((anchor = (String)styleSheet.getStyleProperty(ElementStyleKeys.ANCHOR_NAME)) != null) {
            this.drawAnchor(box);
        }
        if ((bookmark = (String)styleSheet.getStyleProperty(BandStyleKeys.BOOKMARK)) != null) {
            this.drawBookmark(box, bookmark);
        }
    }

    protected boolean drawPdfScript(RenderNode box) {
        Object attribute = box.getAttributes().getAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/pdf", "scriptAction");
        if (attribute == null) {
            return false;
        }
        String attributeText = String.valueOf(attribute);
        PdfAction action = PdfAction.javaScript((String)attributeText, (PdfWriter)this.writer, (boolean)false);
        AffineTransform affineTransform = this.getGraphics().getTransform();
        float translateX = (float)affineTransform.getTranslateX();
        float leftX = translateX + (float)StrictGeomUtility.toExternalValue(box.getX());
        float rightX = translateX + (float)StrictGeomUtility.toExternalValue(box.getX() + box.getWidth());
        float lowerY = (float)((double)this.globalHeight - StrictGeomUtility.toExternalValue(box.getY() + box.getHeight()));
        float upperY = (float)((double)this.globalHeight - StrictGeomUtility.toExternalValue(box.getY()));
        PdfAnnotation annotation = new PdfAnnotation(this.writer, leftX, lowerY, rightX, upperY, action);
        this.writer.addAnnotation(annotation);
        return true;
    }

    @Override
    protected void drawAnchor(RenderNode content) {
        if (!content.isNodeVisible(this.getDrawArea())) {
            return;
        }
        String anchorName = (String)content.getStyleSheet().getStyleProperty(ElementStyleKeys.ANCHOR_NAME);
        if (anchorName == null) {
            return;
        }
        AffineTransform affineTransform = this.getGraphics().getTransform();
        float translateX = (float)affineTransform.getTranslateX();
        float upperY = translateX + (float)((double)this.globalHeight - StrictGeomUtility.toExternalValue(content.getY()));
        float leftX = (float)StrictGeomUtility.toExternalValue(content.getX());
        PdfDestination dest = new PdfDestination(1, leftX, upperY, 0.0f);
        this.writer.getDirectContent().localDestination(anchorName, dest);
    }

    @Override
    protected void drawBookmark(RenderNode box, String bookmark) {
        if (!box.isNodeVisible(this.getDrawArea())) {
            return;
        }
        PdfOutline root = this.writer.getDirectContent().getRootOutline();
        AffineTransform affineTransform = this.getGraphics().getTransform();
        float translateX = (float)affineTransform.getTranslateX();
        float upperY = translateX + (float)((double)this.globalHeight - StrictGeomUtility.toExternalValue(box.getY()));
        float leftX = (float)StrictGeomUtility.toExternalValue(box.getX());
        PdfDestination dest = new PdfDestination(1, leftX, upperY, 0.0f);
        new PdfOutline(root, dest, bookmark);
    }

    @Override
    protected void drawHyperlink(RenderNode box, String target, String window, String title) {
        if (!box.isNodeVisible(this.getDrawArea())) {
            return;
        }
        PdfAction action = this.createActionForLink(target);
        AffineTransform affineTransform = this.getGraphics().getTransform();
        float translateX = (float)affineTransform.getTranslateX();
        float leftX = translateX + (float)StrictGeomUtility.toExternalValue(box.getX());
        float rightX = translateX + (float)StrictGeomUtility.toExternalValue(box.getX() + box.getWidth());
        float lowerY = (float)((double)this.globalHeight - StrictGeomUtility.toExternalValue(box.getY() + box.getHeight()));
        float upperY = (float)((double)this.globalHeight - StrictGeomUtility.toExternalValue(box.getY()));
        if (action != null) {
            PdfAnnotation annotation = new PdfAnnotation(this.writer, leftX, lowerY, rightX, upperY, action);
            this.writer.addAnnotation(annotation);
        } else if (!StringUtils.isEmpty((String)title)) {
            Rectangle rect = new Rectangle(leftX, lowerY, rightX, upperY);
            PdfAnnotation commentAnnotation = PdfAnnotation.createText((PdfWriter)this.writer, (Rectangle)rect, (String)"Tooltip", (String)title, (boolean)false, null);
            commentAnnotation.setAppearance(PdfAnnotation.APPEARANCE_NORMAL, (PdfTemplate)this.writer.getDirectContent().createAppearance(rect.getWidth(), rect.getHeight()));
            this.writer.addAnnotation(commentAnnotation);
        }
    }

    private PdfAction createActionForLink(String target) {
        if (StringUtils.isEmpty((String)target)) {
            return null;
        }
        PdfAction action = new PdfAction();
        if (target.startsWith("#")) {
            action.put(PdfName.S, (PdfObject)PdfName.GOTO);
            action.put(PdfName.D, (PdfObject)new PdfString(target.substring(1)));
        } else {
            action.put(PdfName.S, (PdfObject)PdfName.URI);
            action.put(PdfName.URI, (PdfObject)new PdfString(target));
        }
        return action;
    }

    @Override
    protected void drawText(RenderableText renderableText, long contentX2) {
        float ascent;
        PdfContentByte cb;
        if (renderableText.getLength() == 0) {
            return;
        }
        long posX = renderableText.getX();
        long posY = renderableText.getY();
        float x1 = (float)StrictGeomUtility.toExternalValue(posX);
        PdfTextSpec textSpec = (PdfTextSpec)this.getTextSpec();
        if (textSpec == null) {
            StyleSheet layoutContext = renderableText.getStyleSheet();
            String fontName = this.getMetaData().getNormalizedFontFamilyName((String)layoutContext.getStyleProperty(TextStyleKeys.FONT));
            String encoding = (String)layoutContext.getStyleProperty(TextStyleKeys.FONTENCODING);
            float fontSize = (float)layoutContext.getDoubleStyleProperty(TextStyleKeys.FONTSIZE, 10.0);
            boolean embed = this.globalEmbed || layoutContext.getBooleanStyleProperty(TextStyleKeys.EMBEDDED_FONT);
            boolean bold = layoutContext.getBooleanStyleProperty(TextStyleKeys.BOLD);
            boolean italics = layoutContext.getBooleanStyleProperty(TextStyleKeys.ITALIC);
            BaseFontFontMetrics fontMetrics = this.getMetaData().getBaseFontFontMetrics(fontName, fontSize, bold, italics, encoding, embed, false);
            PdfGraphics2D g2 = (PdfGraphics2D)this.getGraphics();
            Color cssColor = (Color)layoutContext.getStyleProperty(ElementStyleKeys.PAINT);
            g2.setPaint(cssColor);
            g2.setFillPaint();
            g2.setStrokePaint();
            cb = g2.getRawContentByte();
            textSpec = new PdfTextSpec(layoutContext, this.getMetaData(), g2, fontMetrics, cb);
            this.setTextSpec(textSpec);
            cb.beginText();
            cb.setFontAndSize(fontMetrics.getBaseFont(), fontSize);
        } else {
            cb = textSpec.getContentByte();
        }
        BaseFontFontMetrics baseFontRecord = textSpec.getFontMetrics();
        BaseFont baseFont = baseFontRecord.getBaseFont();
        if (this.legacyLineHeightCalc) {
            float awtAscent = baseFont.getFontDescriptor(9, textSpec.getFontSize());
            float awtLeading = baseFont.getFontDescriptor(11, textSpec.getFontSize());
            ascent = awtAscent + awtLeading;
        } else {
            ascent = baseFont.getFontDescriptor(8, textSpec.getFontSize());
        }
        float y2 = (float)(StrictGeomUtility.toExternalValue(posY) + (double)ascent);
        float y = this.globalHeight - y2;
        AffineTransform affineTransform = textSpec.getGraphics().getTransform();
        float translateX = (float)affineTransform.getTranslateX();
        FontNativeContext nativeContext = baseFontRecord.getNativeContext();
        if (baseFontRecord.isTrueTypeFont() && textSpec.isBold() && !nativeContext.isNativeBold()) {
            float strokeWidth = textSpec.getFontSize() / 30.0f;
            if (strokeWidth == 1.0f) {
                cb.setTextRenderingMode(0);
            } else {
                cb.setTextRenderingMode(2);
                cb.setLineWidth(strokeWidth);
            }
        } else {
            cb.setTextRenderingMode(0);
        }
        if (baseFontRecord.isTrueTypeFont() && textSpec.isItalics() && !nativeContext.isNativeItalics()) {
            float italicAngle = baseFont.getFontDescriptor(4, textSpec.getFontSize());
            if (italicAngle == 0.0f) {
                cb.setTextMatrix(1.0f, 0.0f, 0.21256f, 1.0f, x1 + translateX, y);
            } else {
                cb.setTextMatrix(x1 + translateX, y);
            }
        } else {
            cb.setTextMatrix(x1 + translateX, y);
        }
        PdfOutputProcessorMetaData metaData = this.getMetaData();
        GlyphList gs = renderableText.getGlyphs();
        int offset = renderableText.getOffset();
        CodePointBuffer codePointBuffer = this.getCodePointBuffer();
        if (metaData.isFeatureSupported(OutputProcessorFeature.FAST_FONTRENDERING) && this.isNormalTextSpacing(renderableText)) {
            int maxLength = renderableText.computeMaximumTextSize(contentX2);
            String text = gs.getText(renderableText.getOffset(), maxLength, codePointBuffer);
            cb.showText(text);
        } else {
            PdfTextArray textArray = new PdfTextArray();
            StringBuilder buffer = new StringBuilder(gs.getSize());
            int maxPos = offset + renderableText.computeMaximumTextSize(contentX2);
            for (int i = offset; i < maxPos; ++i) {
                float optimum;
                Glyph g = gs.getGlyph(i);
                Spacing spacing = g.getSpacing();
                if (i != offset && (optimum = (float)StrictGeomUtility.toFontMetricsValue(spacing.getMinimum())) != 0.0f) {
                    textArray.add(buffer.toString());
                    textArray.add(-optimum / textSpec.getFontSize());
                    buffer.setLength(0);
                }
                String text = gs.getGlyphAsString(i, codePointBuffer);
                buffer.append(text);
            }
            if (buffer.length() > 0) {
                textArray.add(buffer.toString());
            }
            cb.showText(textArray);
        }
    }

    @Override
    protected void processParagraphChilds(ParagraphRenderBox box) {
        try {
            this.paragraphContext = box;
            super.processParagraphChilds(box);
        }
        finally {
            this.paragraphContext = null;
        }
    }

    private float computeLeadingSafetyMargin(RenderableComplexText node) {
        if (this.paragraphContext == null) {
            return -0.1f;
        }
        ElementAlignment alignment = node.getNext() == null ? this.paragraphContext.getLastLineAlignment() : this.paragraphContext.getTextAlignment();
        if (ElementAlignment.LEFT.equals(alignment)) {
            return 0.0f;
        }
        if (ElementAlignment.RIGHT.equals(alignment)) {
            return -0.2f;
        }
        if (ElementAlignment.CENTER.equals(alignment)) {
            return -0.1f;
        }
        if (this.computeRunDirection(node) == 3) {
            return -0.2f;
        }
        return 0.0f;
    }

    private float computeTrailingSafetyMargin(RenderableComplexText node) {
        if (this.paragraphContext == null) {
            return 0.1f;
        }
        ElementAlignment alignment = node.getNext() == null ? this.paragraphContext.getLastLineAlignment() : this.paragraphContext.getTextAlignment();
        if (ElementAlignment.LEFT.equals(alignment)) {
            return 0.2f;
        }
        if (ElementAlignment.RIGHT.equals(alignment)) {
            return 0.0f;
        }
        if (ElementAlignment.CENTER.equals(alignment)) {
            return 0.1f;
        }
        if (this.computeRunDirection(node) == 3) {
            return 0.0f;
        }
        return 0.2f;
    }

    private int mapAlignment(RenderableComplexText node) {
        ElementAlignment alignment = node.getNext() == null ? this.paragraphContext.getLastLineAlignment() : this.paragraphContext.getTextAlignment();
        if (ElementAlignment.LEFT.equals(alignment)) {
            return 0;
        }
        if (ElementAlignment.RIGHT.equals(alignment)) {
            return 2;
        }
        if (ElementAlignment.CENTER.equals(alignment)) {
            return 1;
        }
        return 3;
    }

    @Override
    protected void drawComplexText(RenderableComplexText node, Graphics2D g2) {
        try {
            Phrase p = this.createPhrase(node);
            ColumnConfig cc = this.createColumnText(node);
            PdfGraphics2D pg2 = (PdfGraphics2D)this.getGraphics();
            PdfContentByte cb = pg2.getRawContentByte();
            ColumnText ct = cc.reconfigure(cb, p);
            ct.setText(p);
            if (ct.go(false) == 2) {
                throw new InvalidReportStateException("iText signaled an error when printing text. Failing to prevent silent data-loss: Width=" + ct.getFilledWidth());
            }
        }
        catch (DocumentException e) {
            throw new InvalidReportStateException(e);
        }
    }

    private ColumnConfig createColumnText(RenderableComplexText node) {
        AffineTransform affineTransform = this.getGraphics().getTransform();
        float translateX = (float)affineTransform.getTranslateX();
        float width = (float)StrictGeomUtility.toExternalValue(node.getWidth());
        float nodeX = (float)StrictGeomUtility.toExternalValue(node.getX());
        float marginLeft = width * this.computeLeadingSafetyMargin(node);
        float llx = translateX + nodeX + marginLeft;
        float marginRight = width * this.computeTrailingSafetyMargin(node);
        float urx = translateX + nodeX + width + marginRight;
        float y2 = (float)StrictGeomUtility.toExternalValue(node.getY());
        float lly = this.globalHeight - y2;
        float ury = (float)((double)lly - 1.2 * StrictGeomUtility.toExternalValue(node.getHeight()));
        ColumnConfig ct = new ColumnConfig(llx, lly, urx, ury, node.getParagraphFontMetrics().getAscent(), this.mapAlignment(node), this.computeRunDirection(node));
        return ct;
    }

    private Phrase createPhrase(RenderableComplexText node) {
        Phrase p = new Phrase();
        RichTextSpec text = node.getRichText();
        for (RichTextSpec.StyledChunk c : text.getStyleChunks()) {
            TypedMapWrapper<AttributedCharacterIterator.Attribute, Object> attributes = new TypedMapWrapper<AttributedCharacterIterator.Attribute, Object>(c.getAttributes());
            Number size = attributes.get(TextAttribute.SIZE, Float.valueOf(10.0f), Number.class);
            PdfTextSpec pdfTextSpec = this.computeFont(c);
            int style = this.computeStyle(attributes, pdfTextSpec);
            Color paint = (Color)c.getStyleSheet().getStyleProperty(ElementStyleKeys.PAINT);
            BaseFont baseFont = pdfTextSpec.getFontMetrics().getBaseFont();
            Font font = new Font(baseFont, size.floatValue(), style, paint);
            if (c.getOriginatingTextNode() instanceof RenderableReplacedContentBox) {
                RenderableReplacedContentBox content = (RenderableReplacedContentBox)c.getOriginatingTextNode();
                Image image = this.imageHandler.createImage(content);
                if (image == null) continue;
                Chunk chunk = new Chunk(image, 0.0f, 0.0f);
                p.add((Object)chunk);
                continue;
            }
            String textToPrint = c.getText();
            Chunk chunk = new Chunk(textToPrint, font);
            p.add((Object)chunk);
        }
        return p;
    }

    private int computeRunDirection(RenderableComplexText node) {
        Object styleProperty = node.getStyleSheet().getStyleProperty(TextStyleKeys.DIRECTION, TextDirection.LTR);
        if (TextDirection.RTL.equals(styleProperty)) {
            return 3;
        }
        return 2;
    }

    private PdfTextSpec computeFont(RichTextSpec.StyledChunk c) {
        StyleSheet layoutContext = c.getStyleSheet();
        PdfGraphics2D g2 = (PdfGraphics2D)this.getGraphics();
        PdfContentByte cb = g2.getRawContentByte();
        TypedMapWrapper<AttributedCharacterIterator.Attribute, Object> attributes = new TypedMapWrapper<AttributedCharacterIterator.Attribute, Object>(c.getAttributes());
        String fontName = attributes.get(TextAttribute.FAMILY, String.class);
        Number fontSize = attributes.get(TextAttribute.SIZE, Float.valueOf(10.0f), Number.class);
        String encoding = (String)layoutContext.getStyleProperty(TextStyleKeys.FONTENCODING);
        boolean embed = this.globalEmbed || layoutContext.getBooleanStyleProperty(TextStyleKeys.EMBEDDED_FONT);
        Float weightRaw = attributes.get(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR, Float.class);
        Float italicsRaw = attributes.get(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, Float.class);
        BaseFontFontMetrics fontMetrics = this.getMetaData().getBaseFontFontMetrics(fontName, fontSize.doubleValue(), weightRaw.floatValue() >= TextAttribute.WEIGHT_DEMIBOLD.floatValue(), italicsRaw.floatValue() >= TextAttribute.POSTURE_OBLIQUE.floatValue(), encoding, embed, false);
        return new PdfTextSpec(layoutContext, this.getMetaData(), g2, fontMetrics, cb);
    }

    private int computeStyle(TypedMapWrapper<AttributedCharacterIterator.Attribute, Object> attributes, PdfTextSpec pdfTextSpec) {
        Float weight = attributes.get(TextAttribute.WEIGHT, TextAttribute.WEIGHT_REGULAR, Float.class);
        Float italics = attributes.get(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, Float.class);
        boolean underlined = attributes.exists(TextAttribute.UNDERLINE);
        boolean strikethrough = attributes.exists(TextAttribute.STRIKETHROUGH);
        FontNativeContext nativeContext = pdfTextSpec.getFontMetrics().getNativeContext();
        int style = 0;
        if (!nativeContext.isNativeBold() && weight.floatValue() >= TextAttribute.WEIGHT_DEMIBOLD.floatValue()) {
            style |= 1;
        }
        if (!nativeContext.isNativeItalics() && italics.floatValue() >= TextAttribute.POSTURE_OBLIQUE.floatValue()) {
            style |= 2;
        }
        if (underlined) {
            style |= 4;
        }
        if (strikethrough) {
            style |= 8;
        }
        return style;
    }

    @Override
    protected boolean startInlineBox(InlineRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return false;
        }
        if (!box.isBoxVisible(this.getDrawArea())) {
            return false;
        }
        return super.startInlineBox(box);
    }

    @Override
    protected void finishInlineBox(InlineRenderBox box) {
        if (!box.getStaticBoxLayoutProperties().isVisible()) {
            return;
        }
        if (!box.isBoxVisible(this.getDrawArea())) {
            return;
        }
        super.finishInlineBox(box);
    }

    @Override
    protected void drawReplacedContent(RenderableReplacedContentBox content) {
        ImageContainer imageContainer;
        Image instance;
        Graphics2D g2 = this.getGraphics();
        Object o = content.getContent().getRawObject();
        if (o instanceof DrawableWrapper) {
            DrawableWrapper drawableWrapper = (DrawableWrapper)o;
            if (this.drawDrawable(content, g2, drawableWrapper)) {
                this.drawImageMap(content);
            }
            return;
        }
        if (o instanceof java.awt.Image) {
            if (this.drawImage(content, (java.awt.Image)o)) {
                this.drawImageMap(content);
            }
            return;
        }
        if (o instanceof URLImageContainer && (instance = this.imageHandler.createImage((URLImageContainer)(imageContainer = (URLImageContainer)o))) != null) {
            try {
                ResourceManager resourceManager = this.getResourceManager();
                ResourceKey resource = imageContainer.getResourceKey();
                Resource imageWrapped = resourceManager.create(resource, null, java.awt.Image.class);
                java.awt.Image image = (java.awt.Image)imageWrapped.getResource();
                if (this.drawImage(content, image, instance)) {
                    this.drawImageMap(content);
                }
                return;
            }
            catch (Exception e) {
                logger.info((Object)"URL-image cannot be rendered, as the image was not loadable.", (Throwable)e);
            }
        }
        if (o instanceof LocalImageContainer) {
            imageContainer = (LocalImageContainer)o;
            java.awt.Image image = imageContainer.getImage();
            if (this.drawImage(content, image)) {
                this.drawImageMap(content);
            }
        } else {
            logger.debug((Object)("Unable to handle " + o));
        }
    }

    protected void drawImageMap(RenderableReplacedContentBox content) {
        if (this.version < '6') {
            return;
        }
        ImageMap imageMap = RenderUtility.extractImageMap(content);
        if (imageMap == null) {
            return;
        }
        ImageMapEntry[] imageMapEntries = imageMap.getMapEntries();
        for (int i = 0; i < imageMapEntries.length; ++i) {
            ImageMapEntry imageMapEntry = imageMapEntries[i];
            String link = imageMapEntry.getAttribute("http://www.w3.org/1999/xhtml", "href");
            String tooltip = imageMapEntry.getAttribute("http://www.w3.org/1999/xhtml", "title");
            if (StringUtils.isEmpty((String)tooltip)) continue;
            AffineTransform affineTransform = this.getGraphics().getTransform();
            float translateX = (float)affineTransform.getTranslateX();
            int x = (int)((double)translateX + StrictGeomUtility.toExternalValue(content.getX()));
            int y = (int)StrictGeomUtility.toExternalValue(content.getY());
            float[] translatedCoords = this.translateCoordinates(imageMapEntry.getAreaCoordinates(), x, y);
            PolygonAnnotation polygonAnnotation = new PolygonAnnotation(this.writer, translatedCoords);
            polygonAnnotation.put(PdfName.CONTENTS, (PdfObject)new PdfString(tooltip, "UnicodeBig"));
            this.writer.addAnnotation((PdfAnnotation)polygonAnnotation);
        }
    }

    private float[] translateCoordinates(float[] coords, float dx, float dy) {
        float[] floats = (float[])coords.clone();
        if (floats.length % 2 != 0) {
            throw new IllegalArgumentException("Corrdinates are not x/y pairs");
        }
        for (int i = 0; i < floats.length; i += 2) {
            int n = i;
            floats[n] = floats[n] + dx;
            floats[i + 1] = this.globalHeight - floats[i + 1] + dy;
        }
        return floats;
    }

    protected boolean drawImage(RenderableReplacedContentBox content, java.awt.Image image, Image itextImage) {
        AffineTransform scaleTransform;
        Graphics2D g2;
        StyleSheet layoutContext = content.getStyleSheet();
        boolean shouldScale = layoutContext.getBooleanStyleProperty(ElementStyleKeys.SCALE);
        int x = (int)StrictGeomUtility.toExternalValue(content.getX());
        int y = (int)StrictGeomUtility.toExternalValue(content.getY());
        int width = (int)StrictGeomUtility.toExternalValue(content.getWidth());
        int height = (int)StrictGeomUtility.toExternalValue(content.getHeight());
        if (width == 0 || height == 0) {
            logger.debug((Object)("Error: Image area is empty: " + content));
            return false;
        }
        WaitingImageObserver obs = new WaitingImageObserver(image);
        obs.waitImageLoaded();
        int imageWidth = image.getWidth((ImageObserver)obs);
        int imageHeight = image.getHeight((ImageObserver)obs);
        if (imageWidth < 1 || imageHeight < 1) {
            return false;
        }
        Rectangle2D.Double drawAreaBounds = new Rectangle2D.Double(x, y, width, height);
        if (!shouldScale) {
            double deviceScaleFactor = 1.0;
            double devResolution = this.getMetaData().getNumericFeatureValue(OutputProcessorFeature.DEVICE_RESOLUTION);
            if (this.getMetaData().isFeatureSupported(OutputProcessorFeature.IMAGE_RESOLUTION_MAPPING) && devResolution != 72.0 && devResolution > 0.0) {
                deviceScaleFactor = 72.0 / devResolution;
            }
            int clipWidth = Math.min(width, (int)Math.ceil(deviceScaleFactor * (double)imageWidth));
            int clipHeight = Math.min(height, (int)Math.ceil(deviceScaleFactor * (double)imageHeight));
            ElementAlignment horizontalAlignment = (ElementAlignment)layoutContext.getStyleProperty(ElementStyleKeys.ALIGNMENT);
            ElementAlignment verticalAlignment = (ElementAlignment)layoutContext.getStyleProperty(ElementStyleKeys.VALIGNMENT);
            int alignmentX = (int)RenderUtility.computeHorizontalAlignment(horizontalAlignment, width, clipWidth);
            int alignmentY = (int)RenderUtility.computeVerticalAlignment(verticalAlignment, height, clipHeight);
            g2 = (Graphics2D)this.getGraphics().create();
            g2.clip(drawAreaBounds);
            g2.translate(x, y);
            g2.translate(alignmentX, alignmentY);
            g2.clip(new Rectangle2D.Float(0.0f, 0.0f, clipWidth, clipHeight));
            g2.scale(deviceScaleFactor, deviceScaleFactor);
            scaleTransform = null;
        } else {
            double scaleY;
            double scaleX;
            g2 = (Graphics2D)this.getGraphics().create();
            g2.clip(drawAreaBounds);
            g2.translate(x, y);
            g2.clip(new Rectangle2D.Float(0.0f, 0.0f, width, height));
            boolean keepAspectRatio = layoutContext.getBooleanStyleProperty(ElementStyleKeys.KEEP_ASPECT_RATIO);
            if (keepAspectRatio) {
                double scaleFactor;
                scaleX = scaleFactor = Math.min((double)width / (double)imageWidth, (double)height / (double)imageHeight);
                scaleY = scaleFactor;
            } else {
                scaleX = (double)width / (double)imageWidth;
                scaleY = (double)height / (double)imageHeight;
            }
            int clipWidth = (int)(scaleX * (double)imageWidth);
            int clipHeight = (int)(scaleY * (double)imageHeight);
            ElementAlignment horizontalAlignment = (ElementAlignment)layoutContext.getStyleProperty(ElementStyleKeys.ALIGNMENT);
            ElementAlignment verticalAlignment = (ElementAlignment)layoutContext.getStyleProperty(ElementStyleKeys.VALIGNMENT);
            int alignmentX = (int)RenderUtility.computeHorizontalAlignment(horizontalAlignment, width, clipWidth);
            int alignmentY = (int)RenderUtility.computeVerticalAlignment(verticalAlignment, height, clipHeight);
            g2.translate(alignmentX, alignmentY);
            scaleTransform = AffineTransform.getScaleInstance(scaleX, scaleY);
        }
        PdfGraphics2D pdfGraphics2D = (PdfGraphics2D)g2;
        pdfGraphics2D.drawPdfImage(itextImage, image, scaleTransform, null);
        g2.dispose();
        return true;
    }

    private static class ColumnConfig {
        private float llx;
        private float lly;
        private float urx;
        private float ury;
        private float leading;
        private int alignment;
        private int runDirection;

        private ColumnConfig(float llx, float lly, float urx, float ury, float leading, int alignment, int runDirection) {
            this.llx = llx;
            this.lly = lly;
            this.urx = urx;
            this.ury = ury;
            this.leading = leading;
            this.alignment = alignment;
            this.runDirection = runDirection;
        }

        public ColumnText reconfigure(PdfContentByte cb, Phrase p) {
            float filledWidth = ColumnText.getWidth((Phrase)p, (int)this.runDirection, (int)0) + 0.5f;
            ColumnText ct = new ColumnText(cb);
            ct.setRunDirection(this.runDirection);
            if (this.alignment == 0) {
                ct.setSimpleColumn(this.llx, this.lly, this.llx + filledWidth, this.ury, this.leading, this.alignment);
            } else if (this.alignment == 2) {
                ct.setSimpleColumn(this.urx - filledWidth, this.lly, this.urx, this.ury, this.leading, this.alignment);
            } else if (this.alignment == 1) {
                float delta = (this.urx - this.llx - filledWidth) / 2.0f;
                ct.setSimpleColumn(this.urx + delta, this.lly, this.urx - delta, this.ury, this.leading, this.alignment);
            } else {
                ct.setSimpleColumn(this.llx, this.lly, this.urx, this.ury, this.leading, this.alignment);
            }
            return ct;
        }
    }

    protected static class PdfTextSpec
    extends LogicalPageDrawable.TextSpec {
        private BaseFontFontMetrics fontMetrics;
        private PdfContentByte contentByte;

        protected PdfTextSpec(StyleSheet layoutContext, PdfOutputProcessorMetaData metaData, PdfGraphics2D g2, BaseFontFontMetrics fontMetrics, PdfContentByte cb) {
            super(layoutContext, metaData, g2);
            if (fontMetrics == null) {
                throw new NullPointerException();
            }
            if (cb == null) {
                throw new NullPointerException();
            }
            this.fontMetrics = fontMetrics;
            this.contentByte = cb;
        }

        public BaseFontFontMetrics getFontMetrics() {
            return this.fontMetrics;
        }

        public PdfContentByte getContentByte() {
            return this.contentByte;
        }

        @Override
        public void close() {
            this.contentByte.endText();
        }
    }
}

