/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.helper;

import com.lowagie.text.BadElementException;
import com.lowagie.text.DocumentException;
import java.awt.Image;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.core.ImageContainer;
import org.pentaho.reporting.engine.classic.core.LocalImageContainer;
import org.pentaho.reporting.engine.classic.core.URLImageContainer;
import org.pentaho.reporting.engine.classic.core.layout.output.RenderUtility;
import org.pentaho.reporting.libraries.base.encoder.UnsupportedEncoderException;
import org.pentaho.reporting.libraries.base.util.LFUMap;
import org.pentaho.reporting.libraries.base.util.StringUtils;
import org.pentaho.reporting.libraries.base.util.WaitingImageObserver;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;

public class RTFImageCache {
    private LFUMap cachedImages;
    private static final Log logger = LogFactory.getLog(RTFImageCache.class);
    private ResourceManager resourceManager;

    public RTFImageCache(ResourceManager resourceManager) {
        if (resourceManager == null) {
            throw new NullPointerException();
        }
        this.resourceManager = resourceManager;
        this.cachedImages = new LFUMap(100);
    }

    private boolean isSupportedFormat(URL sourceURL) {
        String file = sourceURL.getFile();
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".png")) {
            return true;
        }
        if (StringUtils.endsWithIgnoreCase((String)file, (String)".jpg") || StringUtils.endsWithIgnoreCase((String)file, (String)".jpeg")) {
            return true;
        }
        return StringUtils.endsWithIgnoreCase((String)file, (String)".bmp") || StringUtils.endsWithIgnoreCase((String)file, (String)".ico");
    }

    public com.lowagie.text.Image getImage(ImageContainer reference) throws DocumentException, IOException {
        com.lowagie.text.Image cachedImage;
        LocalImageContainer localImageContainer;
        URLImageContainer urlImageContainer;
        ResourceKey url;
        if (reference == null) {
            throw new NullPointerException();
        }
        Object identity = null;
        Image image = null;
        if (reference instanceof URLImageContainer && (url = (urlImageContainer = (URLImageContainer)reference).getResourceKey()) != null && urlImageContainer.isLoadable()) {
            identity = url;
            com.lowagie.text.Image cached = (com.lowagie.text.Image)this.cachedImages.get(identity);
            if (cached != null) {
                return cached;
            }
            try {
                ResourceData resourceData = this.resourceManager.load(url);
                byte[] data = resourceData.getResource(this.resourceManager);
                com.lowagie.text.Image itextimage = com.lowagie.text.Image.getInstance((byte[])data);
                this.cachedImages.put(identity, (Object)itextimage);
                return itextimage;
            }
            catch (ResourceException re) {
                logger.info((Object)"Caught illegal Image, will recode to PNG instead", (Throwable)re);
            }
            catch (BadElementException be) {
                logger.info((Object)"Caught illegal Image, will recode to PNG instead", (Throwable)be);
            }
            catch (IOException ioe) {
                logger.info((Object)"Unable to read the raw-data, will try to recode image-data.", (Throwable)ioe);
            }
            try {
                Resource resource = this.resourceManager.create(url, null, com.lowagie.text.Image.class);
                image = (Image)resource.getResource();
            }
            catch (ResourceException re) {
                logger.info((Object)"Caught illegal Image, will try to find local instance", (Throwable)re);
            }
        }
        if (reference instanceof LocalImageContainer && image == null && (image = (localImageContainer = (LocalImageContainer)reference).getImage()) != null && (identity = localImageContainer.getIdentity()) != null && (cachedImage = (com.lowagie.text.Image)this.cachedImages.get(identity)) != null) {
            return cachedImage;
        }
        if (image == null) {
            return null;
        }
        WaitingImageObserver obs = new WaitingImageObserver(image);
        obs.waitImageLoaded();
        try {
            byte[] data = RenderUtility.encodeImage(image);
            com.lowagie.text.Image itextimage = com.lowagie.text.Image.getInstance((byte[])data);
            if (identity != null) {
                this.cachedImages.put(identity, (Object)itextimage);
            }
            return itextimage;
        }
        catch (UnsupportedEncoderException uee) {
            logger.warn((Object)"Assertation-Failure: PNG encoding failed.", (Throwable)uee);
            return null;
        }
    }
}

