/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.data.compounddata.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.pentaho.reporting.engine.classic.core.CompoundDataFactory;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleDataFactoryWriterHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterException;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterState;
import org.pentaho.reporting.engine.classic.core.modules.parser.bundle.writer.BundleWriterUtilities;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.docbundle.BundleUtilities;
import org.pentaho.reporting.libraries.docbundle.DocumentBundle;
import org.pentaho.reporting.libraries.docbundle.WriteableDocumentBundle;
import org.pentaho.reporting.libraries.xmlns.common.AttributeList;
import org.pentaho.reporting.libraries.xmlns.writer.DefaultTagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.TagDescription;
import org.pentaho.reporting.libraries.xmlns.writer.XmlWriter;

public class CompoundDataFactoryWriteHandler
implements BundleDataFactoryWriterHandler {
    @Override
    public String writeDataFactory(WriteableDocumentBundle bundle, DataFactory dataFactory, BundleWriterState state) throws IOException, BundleWriterException {
        if (bundle == null) {
            throw new NullPointerException();
        }
        if (dataFactory == null) {
            throw new NullPointerException();
        }
        if (state == null) {
            throw new NullPointerException();
        }
        CompoundDataFactory compoundDataFactory = (CompoundDataFactory)dataFactory;
        String fileName = BundleUtilities.getUniqueName((DocumentBundle)bundle, (String)state.getFileName(), (String)"datasources/compound-ds{0}.xml");
        if (fileName == null) {
            throw new IOException("Unable to generate unique name for Inline-Data-Source");
        }
        OutputStream outputStream = bundle.createEntry(fileName, "text/xml");
        DefaultTagDescription tagDescription = new DefaultTagDescription();
        tagDescription.setDefaultNamespace("http://reporting.pentaho.org/namespaces/datasources/compound/1.0");
        tagDescription.setNamespaceHasCData("http://reporting.pentaho.org/namespaces/datasources/compound/1.0", false);
        XmlWriter xmlWriter = new XmlWriter((Writer)new OutputStreamWriter(outputStream, "UTF-8"), (TagDescription)tagDescription, "  ", "\n");
        AttributeList rootAttrs = new AttributeList();
        rootAttrs.addNamespaceDeclaration("data", "http://reporting.pentaho.org/namespaces/datasources/compound/1.0");
        xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/compound/1.0", "compound-datasource", rootAttrs, false);
        for (int i = 0; i < compoundDataFactory.size(); ++i) {
            DataFactory df = compoundDataFactory.get(i);
            BundleDataFactoryWriterHandler writerHandler = BundleWriterUtilities.lookupWriteHandler(df);
            if (writerHandler == null) {
                throw new BundleWriterException("Unable to find writer-handler for data-factory " + df.getClass());
            }
            String file = writerHandler.writeDataFactory(bundle, df, state);
            if (file == null) {
                throw new BundleWriterException("Data-factory writer did not create a file for " + df.getClass());
            }
            String refFile = IOUtils.getInstance().createRelativePath(file, fileName);
            xmlWriter.writeTag("http://reporting.pentaho.org/namespaces/datasources/compound/1.0", "data-factory", "href", refFile, true);
        }
        xmlWriter.writeCloseTag();
        xmlWriter.close();
        return fileName;
    }
}

