/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.AbstractObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectFactoryException;

public class DateObjectDescription
extends AbstractObjectDescription {
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ", Locale.US);

    public DateObjectDescription() {
        super(Date.class);
        this.setParameterDefinition("year", Integer.class);
        this.setParameterDefinition("month", Integer.class);
        this.setParameterDefinition("day", Integer.class);
        this.setParameterDefinition("value", String.class);
    }

    @Override
    public Object createObject() {
        Object value = this.getParameter("value");
        if (value != null) {
            String svalue = String.valueOf(value);
            try {
                return this.dateFormat.parse(svalue);
            }
            catch (Exception e) {
                return null;
            }
        }
        int y = this.getIntParameter("year");
        int m = this.getIntParameter("month");
        int d = this.getIntParameter("day");
        return new GregorianCalendar(y, m, d).getTime();
    }

    private int getIntParameter(String param) {
        Integer p = (Integer)this.getParameter(param);
        if (p == null) {
            return 0;
        }
        return p;
    }

    @Override
    public void setParameterFromObject(Object o) throws ObjectFactoryException {
        if (!(o instanceof Date)) {
            throw new ObjectFactoryException("Is no instance of java.util.Date");
        }
        this.setParameter("value", this.dateFormat.format((Date)o));
    }
}

