/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.PropertyAttributes;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ClassFactory;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.factory.base.ObjectDescription;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.BasicObjectReadHandler;
import org.pentaho.reporting.engine.classic.core.modules.parser.ext.readhandlers.ObjectFactoryUtility;
import org.pentaho.reporting.libraries.xmlns.parser.ParseException;
import org.pentaho.reporting.libraries.xmlns.parser.XmlReadHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CompoundObjectReadHandler
extends BasicObjectReadHandler {
    private HashMap basicObjects = new HashMap();
    private HashMap compoundObjects = new HashMap();

    public CompoundObjectReadHandler(ObjectDescription objectDescription) {
        super(objectDescription);
    }

    protected HashMap getBasicObjects() {
        return this.basicObjects;
    }

    protected HashMap getCompoundObjects() {
        return this.compoundObjects;
    }

    @Override
    protected void doneParsing() throws SAXException {
        ObjectDescription objectDescription = this.getObjectDescription();
        for (Map.Entry entry : this.basicObjects.entrySet()) {
            String name = (String)entry.getKey();
            BasicObjectReadHandler readHandler = (BasicObjectReadHandler)((Object)entry.getValue());
            objectDescription.setParameter(name, readHandler.getObject());
        }
        for (Map.Entry entry : this.compoundObjects.entrySet()) {
            String name = (String)entry.getKey();
            CompoundObjectReadHandler readHandler = (CompoundObjectReadHandler)((Object)entry.getValue());
            objectDescription.setParameter(name, readHandler.getObject());
        }
    }

    @Override
    protected XmlReadHandler getHandlerForChild(String uri, String tagName, PropertyAttributes atts) throws SAXException {
        if (!this.isSameNamespace(uri)) {
            return null;
        }
        if ("basic-object".equals(tagName)) {
            return this.handleBasicObject(atts);
        }
        if ("compound-object".equals(tagName)) {
            return this.handleCompoundObject(atts);
        }
        return null;
    }

    protected XmlReadHandler handleBasicObject(Attributes atts) throws ParseException {
        String name = atts.getValue(this.getUri(), "name");
        if (name == null) {
            throw new ParseException("Required attribute 'name' is missing.", this.getLocator());
        }
        ClassFactory fact = this.getClassFactory();
        ObjectDescription currentOd = this.getObjectDescription();
        Class paramDesc = currentOd.getParameterDefinition(name);
        if (paramDesc == null) {
            currentOd.getParameterDefinition(name);
            throw new ParseException("The parameter type for '" + name + "' is not known.", this.getLocator());
        }
        ObjectDescription objectDescription = ObjectFactoryUtility.findDescription(fact, paramDesc, this.getLocator());
        BasicObjectReadHandler readHandler = new BasicObjectReadHandler(objectDescription);
        this.basicObjects.put(name, readHandler);
        return readHandler;
    }

    protected XmlReadHandler handleCompoundObject(Attributes atts) throws ParseException {
        String name = atts.getValue(this.getUri(), "name");
        if (name == null) {
            throw new ParseException("Required attribute 'name' is missing.", this.getLocator());
        }
        ClassFactory fact = this.getClassFactory();
        ObjectDescription currentObjDesc = this.getObjectDescription();
        Class parameterDefinition = currentObjDesc.getParameterDefinition(name);
        if (parameterDefinition == null) {
            throw new ParseException("No such parameter description: " + name, this.getLocator());
        }
        ObjectDescription objectDescription = ObjectFactoryUtility.findDescription(fact, parameterDefinition, this.getLocator());
        CompoundObjectReadHandler readHandler = new CompoundObjectReadHandler(objectDescription);
        this.compoundObjects.put(name, readHandler);
        return readHandler;
    }

    @Override
    protected void startParsing(PropertyAttributes attrs) throws SAXException {
        this.handleStartParsing(attrs);
    }
}

